/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.servicebinding.decorator;

import io.dekorate.Logger;
import io.dekorate.LoggerFactory;
import io.dekorate.kubernetes.config.Env;
import io.dekorate.kubernetes.decorator.Decorator;
import io.dekorate.kubernetes.decorator.ResourceProvidingDecorator;
import io.dekorate.servicebinding.config.ApplicationConfig;
import io.dekorate.servicebinding.config.BindingPathConfig;
import io.dekorate.servicebinding.config.ServiceBindingConfig;
import io.dekorate.servicebinding.config.ServiceConfig;
import io.dekorate.servicebinding.model.Application;
import io.dekorate.servicebinding.model.BindingPath;
import io.dekorate.servicebinding.model.ConfigMapKeyRef;
import io.dekorate.servicebinding.model.ConfigMapKeyRefBuilder;
import io.dekorate.servicebinding.model.CustomEnvVar;
import io.dekorate.servicebinding.model.CustomEnvVarBuilder;
import io.dekorate.servicebinding.model.FieldRef;
import io.dekorate.servicebinding.model.FieldRefBuilder;
import io.dekorate.servicebinding.model.ResourceFieldRef;
import io.dekorate.servicebinding.model.ResourceFieldRefBuilder;
import io.dekorate.servicebinding.model.SecretKeyRef;
import io.dekorate.servicebinding.model.SecretKeyRefBuilder;
import io.dekorate.servicebinding.model.Service;
import io.dekorate.servicebinding.model.ServiceBindingBuilder;
import io.dekorate.servicebinding.model.ServiceBindingFluent;
import io.dekorate.servicebinding.model.ValueFrom;
import io.dekorate.utils.Pluralize;
import io.dekorate.utils.Strings;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.KubernetesListBuilder;
import java.util.Arrays;

public class AddServiceBindingResourceDecorator
extends ResourceProvidingDecorator<KubernetesListBuilder> {
    private final ServiceBindingConfig config;
    private final Logger LOGGER = LoggerFactory.getLogger();

    public AddServiceBindingResourceDecorator(ServiceBindingConfig config) {
        this.config = config;
    }

    public void visit(KubernetesListBuilder list) {
        HasMetadata meta = this.getMandatoryDeploymentHasMetadata(list);
        ServiceBindingBuilder serviceBindingBuilder = (ServiceBindingBuilder)((ServiceBindingFluent.SpecNested)((ServiceBindingFluent.SpecNested)((ServiceBindingFluent.SpecNested)((ServiceBindingFluent.SpecNested)((ServiceBindingFluent.SpecNested)((ServiceBindingFluent.SpecNested)((ServiceBindingFluent.SpecNested)((ServiceBindingBuilder)((ServiceBindingFluent.MetadataNested)((ServiceBindingFluent.MetadataNested)new ServiceBindingBuilder().withNewMetadata().withName(this.getServiceBindingName(this.config.getName(), meta.getMetadata().getName()))).withNamespace(meta.getMetadata().getNamespace())).endMetadata()).withNewSpec().withApplication(this.getApplication(this.config.getApplication(), this.config.getBindingPath(), meta))).withEnvVarPrefix(this.getEnvVarPrefix(this.config.getEnvVarPrefix()))).withServices(this.getServices(this.config.getServices()))).withCustomEnvVar(this.getCustomEnvVar(this.config.getCustomEnvVar()))).withDetectBindingResources(this.config.isDetectBindingResources())).withBindAsFiles(this.config.isBindAsFiles())).withMountPath(!this.config.getMountPath().equals("") ? this.config.getMountPath() : null)).endSpec();
        list.addToItems((VisitableBuilder)serviceBindingBuilder);
    }

    public Class<? extends Decorator>[] after() {
        return new Class[]{ResourceProvidingDecorator.class};
    }

    private Service[] getServices(ServiceConfig[] services) {
        return (Service[])Arrays.stream(services).map(s -> new Service(s.getGroup(), s.getVersion(), s.getKind(), s.getName(), s.getId(), Strings.isNotNullOrEmpty((String)s.getNamespace()) ? s.getNamespace() : null, Strings.isNotNullOrEmpty((String)s.getEnvVarPrefix()) ? s.getEnvVarPrefix() : null)).toArray(Service[]::new);
    }

    private Application getApplication(ApplicationConfig config, BindingPathConfig bindingPathConfig, HasMetadata meta) {
        String[] apiVersion = meta.getApiVersion().split("/");
        String name = config != null && Strings.isNotNullOrEmpty((String)config.getName()) ? config.getName() : meta.getMetadata().getName();
        return new Application(Pluralize.FUNCTION.apply(meta.getKind()).toLowerCase(), meta.getKind(), apiVersion[0], apiVersion[1], name, this.getBindingPath(bindingPathConfig));
    }

    private String getServiceBindingName(String serviceBindingName, String deploymentName) {
        if (Strings.isNotNullOrEmpty((String)serviceBindingName)) {
            return serviceBindingName;
        }
        return deploymentName + "-binding";
    }

    private BindingPath getBindingPath(BindingPathConfig config) {
        String secretPath;
        if (config == null) {
            return null;
        }
        String containerPath = Strings.isNotNullOrEmpty((String)config.getContainerPath()) ? config.getContainerPath() : null;
        String string = secretPath = Strings.isNotNullOrEmpty((String)config.getSecretPath()) ? config.getSecretPath() : null;
        if (containerPath == null && secretPath == null) {
            return null;
        }
        return new BindingPath(containerPath, secretPath);
    }

    private CustomEnvVar[] getCustomEnvVar(Env[] config) {
        return (CustomEnvVar[])Arrays.stream(config).map(s -> ((CustomEnvVarBuilder)((CustomEnvVarBuilder)((CustomEnvVarBuilder)new CustomEnvVarBuilder().withName(Strings.isNotNullOrEmpty((String)s.getName()) ? s.getName() : null)).withValue(this.getEnvValue((Env)s))).withValueFrom(this.getValueFrom((Env)s))).build()).toArray(CustomEnvVar[]::new);
    }

    private String getEnvValue(Env envConfig) {
        if (Strings.isNotNullOrEmpty((String)envConfig.getConfigmap()) || Strings.isNotNullOrEmpty((String)envConfig.getSecret()) || Strings.isNotNullOrEmpty((String)envConfig.getField())) {
            return null;
        }
        return !envConfig.getValue().equals("") ? envConfig.getValue() : null;
    }

    private String getEnvVarPrefix(String envVarPrefix) {
        return Strings.isNotNullOrEmpty((String)envVarPrefix) ? envVarPrefix : null;
    }

    private ValueFrom getValueFrom(Env envConfig) {
        if (envConfig == null) {
            return null;
        }
        ConfigMapKeyRef configMapKeyRef = null;
        SecretKeyRef secretKeyRef = null;
        FieldRef fieldRef = null;
        ResourceFieldRef resourceFieldRef = null;
        if (Strings.isNotNullOrEmpty((String)envConfig.getConfigmap())) {
            configMapKeyRef = this.getConfigMapKeyRef(envConfig);
        }
        if (Strings.isNotNullOrEmpty((String)envConfig.getSecret())) {
            secretKeyRef = this.getSecretKeyRef(envConfig);
        }
        if (Strings.isNotNullOrEmpty((String)envConfig.getField())) {
            fieldRef = this.getFieldRef(envConfig);
        }
        if (Strings.isNotNullOrEmpty((String)envConfig.getResourceField())) {
            resourceFieldRef = this.getResourceFieldRef(envConfig);
        }
        if (configMapKeyRef == null && secretKeyRef == null && fieldRef == null && resourceFieldRef == null) {
            return null;
        }
        return new ValueFrom(configMapKeyRef, secretKeyRef, fieldRef, resourceFieldRef);
    }

    private ConfigMapKeyRef getConfigMapKeyRef(Env envConfig) {
        if (Strings.isNullOrEmpty((String)envConfig.getConfigmap())) {
            return null;
        }
        return ((ConfigMapKeyRefBuilder)((ConfigMapKeyRefBuilder)new ConfigMapKeyRefBuilder().withKey(envConfig.getValue())).withName(envConfig.getConfigmap())).build();
    }

    private SecretKeyRef getSecretKeyRef(Env envConfig) {
        if (Strings.isNullOrEmpty((String)envConfig.getSecret())) {
            return null;
        }
        return ((SecretKeyRefBuilder)((SecretKeyRefBuilder)new SecretKeyRefBuilder().withKey(envConfig.getValue())).withName(envConfig.getSecret())).build();
    }

    private FieldRef getFieldRef(Env envConfig) {
        if (Strings.isNullOrEmpty((String)envConfig.getField())) {
            return null;
        }
        return ((FieldRefBuilder)new FieldRefBuilder().withFieldPath(envConfig.getField())).build();
    }

    private ResourceFieldRef getResourceFieldRef(Env envConfig) {
        this.LOGGER.info("------->>>>");
        this.LOGGER.info(envConfig.getResourceField());
        if (Strings.isNullOrEmpty((String)envConfig.getResourceField())) {
            return null;
        }
        return ((ResourceFieldRefBuilder)new ResourceFieldRefBuilder().withResource(envConfig.getResourceField())).build();
    }
}

