/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.servicebinding.config;

import io.dekorate.kubernetes.config.ApplicationConfigurationFluentImpl;
import io.dekorate.kubernetes.config.Env;
import io.dekorate.kubernetes.config.EnvBuilder;
import io.dekorate.kubernetes.config.EnvFluent;
import io.dekorate.kubernetes.config.EnvFluentImpl;
import io.dekorate.servicebinding.config.ApplicationConfig;
import io.dekorate.servicebinding.config.ApplicationConfigBuilder;
import io.dekorate.servicebinding.config.ApplicationConfigFluentImpl;
import io.dekorate.servicebinding.config.BindingPathConfig;
import io.dekorate.servicebinding.config.BindingPathConfigBuilder;
import io.dekorate.servicebinding.config.BindingPathConfigFluentImpl;
import io.dekorate.servicebinding.config.ServiceBindingConfig;
import io.dekorate.servicebinding.config.ServiceBindingConfigFluent;
import io.dekorate.servicebinding.config.ServiceConfig;
import io.dekorate.servicebinding.config.ServiceConfigBuilder;
import io.dekorate.servicebinding.config.ServiceConfigFluentImpl;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class ServiceBindingConfigFluentImpl<A extends ServiceBindingConfigFluent<A>>
extends ApplicationConfigurationFluentImpl<A>
implements ServiceBindingConfigFluent<A> {
    private ApplicationConfigBuilder application;
    private ArrayList<ServiceConfigBuilder> services = new ArrayList();
    private String envVarPrefix;
    private Boolean detectBindingResources;
    private Boolean bindAsFiles;
    private String mountPath;
    private ArrayList<EnvBuilder> customEnvVar = new ArrayList();
    private BindingPathConfigBuilder bindingPath;

    public ServiceBindingConfigFluentImpl() {
    }

    public ServiceBindingConfigFluentImpl(ServiceBindingConfig instance) {
        this.withProject(instance.getProject());
        this.withAttributes(instance.getAttributes());
        this.withPartOf(instance.getPartOf());
        this.withName(instance.getName());
        this.withVersion(instance.getVersion());
        this.withApplication(instance.getApplication());
        this.withServices(instance.getServices());
        this.withEnvVarPrefix(instance.getEnvVarPrefix());
        this.withDetectBindingResources(instance.getDetectBindingResources());
        this.withBindAsFiles(instance.getBindAsFiles());
        this.withMountPath(instance.getMountPath());
        this.withCustomEnvVar(instance.getCustomEnvVar());
        this.withBindingPath(instance.getBindingPath());
    }

    @Override
    @Deprecated
    public ApplicationConfig getApplication() {
        return this.application != null ? this.application.build() : null;
    }

    @Override
    public ApplicationConfig buildApplication() {
        return this.application != null ? this.application.build() : null;
    }

    @Override
    public A withApplication(ApplicationConfig application) {
        this._visitables.get((Object)"application").remove(this.application);
        if (application != null) {
            this.application = new ApplicationConfigBuilder(application);
            this._visitables.get((Object)"application").add(this.application);
        }
        return (A)this;
    }

    @Override
    public Boolean hasApplication() {
        return this.application != null;
    }

    @Override
    public ServiceBindingConfigFluent.ApplicationNested<A> withNewApplication() {
        return new ApplicationNestedImpl();
    }

    @Override
    public ServiceBindingConfigFluent.ApplicationNested<A> withNewApplicationLike(ApplicationConfig item) {
        return new ApplicationNestedImpl(item);
    }

    @Override
    public ServiceBindingConfigFluent.ApplicationNested<A> editApplication() {
        return this.withNewApplicationLike(this.getApplication());
    }

    @Override
    public ServiceBindingConfigFluent.ApplicationNested<A> editOrNewApplication() {
        return this.withNewApplicationLike(this.getApplication() != null ? this.getApplication() : new ApplicationConfigBuilder().build());
    }

    @Override
    public ServiceBindingConfigFluent.ApplicationNested<A> editOrNewApplicationLike(ApplicationConfig item) {
        return this.withNewApplicationLike(this.getApplication() != null ? this.getApplication() : item);
    }

    @Override
    public A withServices(ServiceConfig ... services) {
        if (this.services != null) {
            this.services.clear();
        }
        if (services != null) {
            for (ServiceConfig item : services) {
                this.addToServices(item);
            }
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public ServiceConfig[] getServices() {
        int size = this.services != null ? this.services.size() : 0;
        ServiceConfig[] result = new ServiceConfig[size];
        if (size == 0) {
            return result;
        }
        int index = 0;
        for (VisitableBuilder visitableBuilder : this.services) {
            result[index++] = (ServiceConfig)((Object)visitableBuilder.build());
        }
        return result;
    }

    @Override
    public ServiceConfig[] buildServices() {
        int size = this.services != null ? this.services.size() : 0;
        ServiceConfig[] result = new ServiceConfig[size];
        if (size == 0) {
            return result;
        }
        int index = 0;
        for (VisitableBuilder visitableBuilder : this.services) {
            result[index++] = (ServiceConfig)((Object)visitableBuilder.build());
        }
        return result;
    }

    @Override
    public ServiceConfig buildService(Integer index) {
        return this.services.get(index).build();
    }

    @Override
    public ServiceConfig buildFirstService() {
        return this.services.get(0).build();
    }

    @Override
    public ServiceConfig buildLastService() {
        return this.services.get(this.services.size() - 1).build();
    }

    @Override
    public ServiceConfig buildMatchingService(Predicate<ServiceConfigBuilder> predicate) {
        for (ServiceConfigBuilder item : this.services) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingService(Predicate<ServiceConfigBuilder> predicate) {
        for (ServiceConfigBuilder item : this.services) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A addToServices(Integer index, ServiceConfig item) {
        if (this.services == null) {
            this.services = new ArrayList();
        }
        ServiceConfigBuilder builder = new ServiceConfigBuilder(item);
        this._visitables.get((Object)"services").add(index >= 0 ? index.intValue() : this._visitables.get((Object)"services").size(), builder);
        this.services.add(index >= 0 ? index.intValue() : this.services.size(), builder);
        return (A)this;
    }

    @Override
    public A setToServices(Integer index, ServiceConfig item) {
        if (this.services == null) {
            this.services = new ArrayList();
        }
        ServiceConfigBuilder builder = new ServiceConfigBuilder(item);
        if (index < 0 || index >= this._visitables.get((Object)"services").size()) {
            this._visitables.get((Object)"services").add(builder);
        } else {
            this._visitables.get((Object)"services").set(index, builder);
        }
        if (index < 0 || index >= this.services.size()) {
            this.services.add(builder);
        } else {
            this.services.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToServices(ServiceConfig ... items) {
        if (this.services == null) {
            this.services = new ArrayList();
        }
        for (ServiceConfig item : items) {
            ServiceConfigBuilder builder = new ServiceConfigBuilder(item);
            this._visitables.get((Object)"services").add(builder);
            this.services.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToServices(Collection<ServiceConfig> items) {
        if (this.services == null) {
            this.services = new ArrayList();
        }
        for (ServiceConfig item : items) {
            ServiceConfigBuilder builder = new ServiceConfigBuilder(item);
            this._visitables.get((Object)"services").add(builder);
            this.services.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromServices(ServiceConfig ... items) {
        for (ServiceConfig item : items) {
            ServiceConfigBuilder builder = new ServiceConfigBuilder(item);
            this._visitables.get((Object)"services").remove(builder);
            if (this.services == null) continue;
            this.services.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromServices(Collection<ServiceConfig> items) {
        for (ServiceConfig item : items) {
            ServiceConfigBuilder builder = new ServiceConfigBuilder(item);
            this._visitables.get((Object)"services").remove(builder);
            if (this.services == null) continue;
            this.services.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromServices(Predicate<ServiceConfigBuilder> predicate) {
        if (this.services == null) {
            return (A)this;
        }
        Iterator<ServiceConfigBuilder> each = this.services.iterator();
        List visitables = this._visitables.get((Object)"services");
        while (each.hasNext()) {
            ServiceConfigBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    public Boolean hasServices() {
        return this.services != null && !this.services.isEmpty();
    }

    @Override
    public ServiceBindingConfigFluent.ServicesNested<A> addNewService() {
        return new ServicesNestedImpl();
    }

    @Override
    public ServiceBindingConfigFluent.ServicesNested<A> addNewServiceLike(ServiceConfig item) {
        return new ServicesNestedImpl(-1, item);
    }

    @Override
    public ServiceBindingConfigFluent.ServicesNested<A> setNewServiceLike(Integer index, ServiceConfig item) {
        return new ServicesNestedImpl(index, item);
    }

    @Override
    public ServiceBindingConfigFluent.ServicesNested<A> editService(Integer index) {
        if (this.services.size() <= index) {
            throw new RuntimeException("Can't edit services. Index exceeds size.");
        }
        return this.setNewServiceLike(index, this.buildService(index));
    }

    @Override
    public ServiceBindingConfigFluent.ServicesNested<A> editFirstService() {
        if (this.services.size() == 0) {
            throw new RuntimeException("Can't edit first services. The list is empty.");
        }
        return this.setNewServiceLike(0, this.buildService(0));
    }

    @Override
    public ServiceBindingConfigFluent.ServicesNested<A> editLastService() {
        int index = this.services.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last services. The list is empty.");
        }
        return this.setNewServiceLike(index, this.buildService(index));
    }

    @Override
    public ServiceBindingConfigFluent.ServicesNested<A> editMatchingService(Predicate<ServiceConfigBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.services.size(); ++i) {
            if (!predicate.test(this.services.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching services. No match found.");
        }
        return this.setNewServiceLike(index, this.buildService(index));
    }

    @Override
    public String getEnvVarPrefix() {
        return this.envVarPrefix;
    }

    @Override
    public A withEnvVarPrefix(String envVarPrefix) {
        this.envVarPrefix = envVarPrefix;
        return (A)this;
    }

    @Override
    public Boolean hasEnvVarPrefix() {
        return this.envVarPrefix != null;
    }

    @Override
    public Boolean getDetectBindingResources() {
        return this.detectBindingResources;
    }

    @Override
    public A withDetectBindingResources(Boolean detectBindingResources) {
        this.detectBindingResources = detectBindingResources;
        return (A)this;
    }

    @Override
    public Boolean hasDetectBindingResources() {
        return this.detectBindingResources != null;
    }

    @Override
    public Boolean getBindAsFiles() {
        return this.bindAsFiles;
    }

    @Override
    public A withBindAsFiles(Boolean bindAsFiles) {
        this.bindAsFiles = bindAsFiles;
        return (A)this;
    }

    @Override
    public Boolean hasBindAsFiles() {
        return this.bindAsFiles != null;
    }

    @Override
    public String getMountPath() {
        return this.mountPath;
    }

    @Override
    public A withMountPath(String mountPath) {
        this.mountPath = mountPath;
        return (A)this;
    }

    @Override
    public Boolean hasMountPath() {
        return this.mountPath != null;
    }

    @Override
    public A withCustomEnvVar(Env ... customEnvVar) {
        if (this.customEnvVar != null) {
            this.customEnvVar.clear();
        }
        if (customEnvVar != null) {
            for (Env item : customEnvVar) {
                this.addToCustomEnvVar(item);
            }
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public Env[] getCustomEnvVar() {
        int size = this.customEnvVar != null ? this.customEnvVar.size() : 0;
        Env[] result = new Env[size];
        if (size == 0) {
            return result;
        }
        int index = 0;
        for (VisitableBuilder visitableBuilder : this.customEnvVar) {
            result[index++] = (Env)visitableBuilder.build();
        }
        return result;
    }

    @Override
    public Env[] buildCustomEnvVar() {
        int size = this.customEnvVar != null ? this.customEnvVar.size() : 0;
        Env[] result = new Env[size];
        if (size == 0) {
            return result;
        }
        int index = 0;
        for (VisitableBuilder visitableBuilder : this.customEnvVar) {
            result[index++] = (Env)visitableBuilder.build();
        }
        return result;
    }

    @Override
    public Env buildCustomEnvVar(Integer index) {
        return this.customEnvVar.get(index).build();
    }

    @Override
    public Env buildFirstCustomEnvVar() {
        return this.customEnvVar.get(0).build();
    }

    @Override
    public Env buildLastCustomEnvVar() {
        return this.customEnvVar.get(this.customEnvVar.size() - 1).build();
    }

    @Override
    public Env buildMatchingCustomEnvVar(Predicate<EnvBuilder> predicate) {
        for (EnvBuilder item : this.customEnvVar) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingCustomEnvVar(Predicate<EnvBuilder> predicate) {
        for (EnvBuilder item : this.customEnvVar) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A addToCustomEnvVar(Integer index, Env item) {
        if (this.customEnvVar == null) {
            this.customEnvVar = new ArrayList();
        }
        EnvBuilder builder = new EnvBuilder(item);
        this._visitables.get((Object)"customEnvVar").add(index >= 0 ? index.intValue() : this._visitables.get((Object)"customEnvVar").size(), builder);
        this.customEnvVar.add(index >= 0 ? index.intValue() : this.customEnvVar.size(), builder);
        return (A)this;
    }

    @Override
    public A setToCustomEnvVar(Integer index, Env item) {
        if (this.customEnvVar == null) {
            this.customEnvVar = new ArrayList();
        }
        EnvBuilder builder = new EnvBuilder(item);
        if (index < 0 || index >= this._visitables.get((Object)"customEnvVar").size()) {
            this._visitables.get((Object)"customEnvVar").add(builder);
        } else {
            this._visitables.get((Object)"customEnvVar").set(index, builder);
        }
        if (index < 0 || index >= this.customEnvVar.size()) {
            this.customEnvVar.add(builder);
        } else {
            this.customEnvVar.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToCustomEnvVar(Env ... items) {
        if (this.customEnvVar == null) {
            this.customEnvVar = new ArrayList();
        }
        for (Env item : items) {
            EnvBuilder builder = new EnvBuilder(item);
            this._visitables.get((Object)"customEnvVar").add(builder);
            this.customEnvVar.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToCustomEnvVar(Collection<Env> items) {
        if (this.customEnvVar == null) {
            this.customEnvVar = new ArrayList();
        }
        for (Env item : items) {
            EnvBuilder builder = new EnvBuilder(item);
            this._visitables.get((Object)"customEnvVar").add(builder);
            this.customEnvVar.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromCustomEnvVar(Env ... items) {
        for (Env item : items) {
            EnvBuilder builder = new EnvBuilder(item);
            this._visitables.get((Object)"customEnvVar").remove(builder);
            if (this.customEnvVar == null) continue;
            this.customEnvVar.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromCustomEnvVar(Collection<Env> items) {
        for (Env item : items) {
            EnvBuilder builder = new EnvBuilder(item);
            this._visitables.get((Object)"customEnvVar").remove(builder);
            if (this.customEnvVar == null) continue;
            this.customEnvVar.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromCustomEnvVar(Predicate<EnvBuilder> predicate) {
        if (this.customEnvVar == null) {
            return (A)this;
        }
        Iterator<EnvBuilder> each = this.customEnvVar.iterator();
        List visitables = this._visitables.get((Object)"customEnvVar");
        while (each.hasNext()) {
            EnvBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    public Boolean hasCustomEnvVar() {
        return this.customEnvVar != null && !this.customEnvVar.isEmpty();
    }

    @Override
    public ServiceBindingConfigFluent.CustomEnvVarNested<A> addNewCustomEnvVar() {
        return new CustomEnvVarNestedImpl();
    }

    @Override
    public ServiceBindingConfigFluent.CustomEnvVarNested<A> addNewCustomEnvVarLike(Env item) {
        return new CustomEnvVarNestedImpl(-1, item);
    }

    @Override
    public ServiceBindingConfigFluent.CustomEnvVarNested<A> setNewCustomEnvVarLike(Integer index, Env item) {
        return new CustomEnvVarNestedImpl(index, item);
    }

    @Override
    public ServiceBindingConfigFluent.CustomEnvVarNested<A> editCustomEnvVar(Integer index) {
        if (this.customEnvVar.size() <= index) {
            throw new RuntimeException("Can't edit customEnvVar. Index exceeds size.");
        }
        return this.setNewCustomEnvVarLike(index, this.buildCustomEnvVar(index));
    }

    @Override
    public ServiceBindingConfigFluent.CustomEnvVarNested<A> editFirstCustomEnvVar() {
        if (this.customEnvVar.size() == 0) {
            throw new RuntimeException("Can't edit first customEnvVar. The list is empty.");
        }
        return this.setNewCustomEnvVarLike(0, this.buildCustomEnvVar(0));
    }

    @Override
    public ServiceBindingConfigFluent.CustomEnvVarNested<A> editLastCustomEnvVar() {
        int index = this.customEnvVar.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last customEnvVar. The list is empty.");
        }
        return this.setNewCustomEnvVarLike(index, this.buildCustomEnvVar(index));
    }

    @Override
    public ServiceBindingConfigFluent.CustomEnvVarNested<A> editMatchingCustomEnvVar(Predicate<EnvBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.customEnvVar.size(); ++i) {
            if (!predicate.test(this.customEnvVar.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching customEnvVar. No match found.");
        }
        return this.setNewCustomEnvVarLike(index, this.buildCustomEnvVar(index));
    }

    @Override
    @Deprecated
    public BindingPathConfig getBindingPath() {
        return this.bindingPath != null ? this.bindingPath.build() : null;
    }

    @Override
    public BindingPathConfig buildBindingPath() {
        return this.bindingPath != null ? this.bindingPath.build() : null;
    }

    @Override
    public A withBindingPath(BindingPathConfig bindingPath) {
        this._visitables.get((Object)"bindingPath").remove(this.bindingPath);
        if (bindingPath != null) {
            this.bindingPath = new BindingPathConfigBuilder(bindingPath);
            this._visitables.get((Object)"bindingPath").add(this.bindingPath);
        }
        return (A)this;
    }

    @Override
    public Boolean hasBindingPath() {
        return this.bindingPath != null;
    }

    @Override
    public ServiceBindingConfigFluent.BindingPathNested<A> withNewBindingPath() {
        return new BindingPathNestedImpl();
    }

    @Override
    public ServiceBindingConfigFluent.BindingPathNested<A> withNewBindingPathLike(BindingPathConfig item) {
        return new BindingPathNestedImpl(item);
    }

    @Override
    public ServiceBindingConfigFluent.BindingPathNested<A> editBindingPath() {
        return this.withNewBindingPathLike(this.getBindingPath());
    }

    @Override
    public ServiceBindingConfigFluent.BindingPathNested<A> editOrNewBindingPath() {
        return this.withNewBindingPathLike(this.getBindingPath() != null ? this.getBindingPath() : new BindingPathConfigBuilder().build());
    }

    @Override
    public ServiceBindingConfigFluent.BindingPathNested<A> editOrNewBindingPathLike(BindingPathConfig item) {
        return this.withNewBindingPathLike(this.getBindingPath() != null ? this.getBindingPath() : item);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ServiceBindingConfigFluentImpl that = (ServiceBindingConfigFluentImpl)o;
        if (this.application != null ? !this.application.equals(that.application) : that.application != null) {
            return false;
        }
        if (this.services != null ? !this.services.equals(that.services) : that.services != null) {
            return false;
        }
        if (this.envVarPrefix != null ? !this.envVarPrefix.equals(that.envVarPrefix) : that.envVarPrefix != null) {
            return false;
        }
        if (this.detectBindingResources != null ? !this.detectBindingResources.equals(that.detectBindingResources) : that.detectBindingResources != null) {
            return false;
        }
        if (this.bindAsFiles != null ? !this.bindAsFiles.equals(that.bindAsFiles) : that.bindAsFiles != null) {
            return false;
        }
        if (this.mountPath != null ? !this.mountPath.equals(that.mountPath) : that.mountPath != null) {
            return false;
        }
        if (this.customEnvVar != null ? !this.customEnvVar.equals(that.customEnvVar) : that.customEnvVar != null) {
            return false;
        }
        return !(this.bindingPath != null ? !this.bindingPath.equals(that.bindingPath) : that.bindingPath != null);
    }

    public int hashCode() {
        return Objects.hash(this.application, this.services, this.envVarPrefix, this.detectBindingResources, this.bindAsFiles, this.mountPath, this.customEnvVar, this.bindingPath, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.application != null) {
            sb.append("application:");
            sb.append(this.application + ",");
        }
        if (this.services != null && !this.services.isEmpty()) {
            sb.append("services:");
            sb.append(this.services + ",");
        }
        if (this.envVarPrefix != null) {
            sb.append("envVarPrefix:");
            sb.append(this.envVarPrefix + ",");
        }
        if (this.detectBindingResources != null) {
            sb.append("detectBindingResources:");
            sb.append(this.detectBindingResources + ",");
        }
        if (this.bindAsFiles != null) {
            sb.append("bindAsFiles:");
            sb.append(this.bindAsFiles + ",");
        }
        if (this.mountPath != null) {
            sb.append("mountPath:");
            sb.append(this.mountPath + ",");
        }
        if (this.customEnvVar != null && !this.customEnvVar.isEmpty()) {
            sb.append("customEnvVar:");
            sb.append(this.customEnvVar + ",");
        }
        if (this.bindingPath != null) {
            sb.append("bindingPath:");
            sb.append(this.bindingPath);
        }
        sb.append("}");
        return sb.toString();
    }

    @Override
    public A withDetectBindingResources() {
        return this.withDetectBindingResources(true);
    }

    @Override
    public A withBindAsFiles() {
        return this.withBindAsFiles(true);
    }

    class BindingPathNestedImpl<N>
    extends BindingPathConfigFluentImpl<ServiceBindingConfigFluent.BindingPathNested<N>>
    implements ServiceBindingConfigFluent.BindingPathNested<N>,
    Nested<N> {
        BindingPathConfigBuilder builder;

        BindingPathNestedImpl(BindingPathConfig item) {
            this.builder = new BindingPathConfigBuilder(this, item);
        }

        BindingPathNestedImpl() {
            this.builder = new BindingPathConfigBuilder(this);
        }

        @Override
        public N and() {
            return (N)ServiceBindingConfigFluentImpl.this.withBindingPath(this.builder.build());
        }

        @Override
        public N endBindingPath() {
            return this.and();
        }
    }

    class CustomEnvVarNestedImpl<N>
    extends EnvFluentImpl<ServiceBindingConfigFluent.CustomEnvVarNested<N>>
    implements ServiceBindingConfigFluent.CustomEnvVarNested<N>,
    Nested<N> {
        EnvBuilder builder;
        Integer index;

        CustomEnvVarNestedImpl(Integer index, Env item) {
            this.index = index;
            this.builder = new EnvBuilder((EnvFluent)this, item);
        }

        CustomEnvVarNestedImpl() {
            this.index = -1;
            this.builder = new EnvBuilder((EnvFluent)this);
        }

        @Override
        public N and() {
            return (N)ServiceBindingConfigFluentImpl.this.setToCustomEnvVar(this.index, (Env)this.builder.build());
        }

        @Override
        public N endCustomEnvVar() {
            return this.and();
        }
    }

    class ServicesNestedImpl<N>
    extends ServiceConfigFluentImpl<ServiceBindingConfigFluent.ServicesNested<N>>
    implements ServiceBindingConfigFluent.ServicesNested<N>,
    Nested<N> {
        ServiceConfigBuilder builder;
        Integer index;

        ServicesNestedImpl(Integer index, ServiceConfig item) {
            this.index = index;
            this.builder = new ServiceConfigBuilder(this, item);
        }

        ServicesNestedImpl() {
            this.index = -1;
            this.builder = new ServiceConfigBuilder(this);
        }

        @Override
        public N and() {
            return (N)ServiceBindingConfigFluentImpl.this.setToServices(this.index, this.builder.build());
        }

        @Override
        public N endService() {
            return this.and();
        }
    }

    class ApplicationNestedImpl<N>
    extends ApplicationConfigFluentImpl<ServiceBindingConfigFluent.ApplicationNested<N>>
    implements ServiceBindingConfigFluent.ApplicationNested<N>,
    Nested<N> {
        ApplicationConfigBuilder builder;

        ApplicationNestedImpl(ApplicationConfig item) {
            this.builder = new ApplicationConfigBuilder(this, item);
        }

        ApplicationNestedImpl() {
            this.builder = new ApplicationConfigBuilder(this);
        }

        @Override
        public N and() {
            return (N)ServiceBindingConfigFluentImpl.this.withApplication(this.builder.build());
        }

        @Override
        public N endApplication() {
            return this.and();
        }
    }
}

