/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.servicebinding.model;

import io.dekorate.servicebinding.model.Application;
import io.dekorate.servicebinding.model.ApplicationBuilder;
import io.dekorate.servicebinding.model.ApplicationFluentImpl;
import io.dekorate.servicebinding.model.CustomEnvVar;
import io.dekorate.servicebinding.model.CustomEnvVarBuilder;
import io.dekorate.servicebinding.model.CustomEnvVarFluentImpl;
import io.dekorate.servicebinding.model.Service;
import io.dekorate.servicebinding.model.ServiceBindingSpec;
import io.dekorate.servicebinding.model.ServiceBindingSpecFluent;
import io.dekorate.servicebinding.model.ServiceBuilder;
import io.dekorate.servicebinding.model.ServiceFluentImpl;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class ServiceBindingSpecFluentImpl<A extends ServiceBindingSpecFluent<A>>
extends BaseFluent<A>
implements ServiceBindingSpecFluent<A> {
    private ApplicationBuilder application;
    private ArrayList<ServiceBuilder> services;
    private String envVarPrefix;
    private boolean detectBindingResources;
    private boolean bindAsFiles;
    private String mountPath;
    private ArrayList<CustomEnvVarBuilder> customEnvVar;

    public ServiceBindingSpecFluentImpl() {
    }

    public ServiceBindingSpecFluentImpl(ServiceBindingSpec instance) {
        this.withApplication(instance.getApplication());
        this.withServices(instance.getServices());
        this.withEnvVarPrefix(instance.getEnvVarPrefix());
        this.withDetectBindingResources(instance.getDetectBindingResources());
        this.withBindAsFiles(instance.isBindAsFiles());
        this.withMountPath(instance.getMountPath());
        this.withCustomEnvVar(instance.getCustomEnvVar());
    }

    @Override
    @Deprecated
    public Application getApplication() {
        return this.application != null ? this.application.build() : null;
    }

    @Override
    public Application buildApplication() {
        return this.application != null ? this.application.build() : null;
    }

    @Override
    public A withApplication(Application application) {
        this._visitables.get((Object)"application").remove(this.application);
        if (application != null) {
            this.application = new ApplicationBuilder(application);
            this._visitables.get((Object)"application").add(this.application);
        } else {
            this.application = null;
            this._visitables.get((Object)"application").remove(this.application);
        }
        return (A)this;
    }

    @Override
    public Boolean hasApplication() {
        return this.application != null;
    }

    @Override
    public ServiceBindingSpecFluent.ApplicationNested<A> withNewApplication() {
        return new ApplicationNestedImpl();
    }

    @Override
    public ServiceBindingSpecFluent.ApplicationNested<A> withNewApplicationLike(Application item) {
        return new ApplicationNestedImpl(item);
    }

    @Override
    public ServiceBindingSpecFluent.ApplicationNested<A> editApplication() {
        return this.withNewApplicationLike(this.getApplication());
    }

    @Override
    public ServiceBindingSpecFluent.ApplicationNested<A> editOrNewApplication() {
        return this.withNewApplicationLike(this.getApplication() != null ? this.getApplication() : new ApplicationBuilder().build());
    }

    @Override
    public ServiceBindingSpecFluent.ApplicationNested<A> editOrNewApplicationLike(Application item) {
        return this.withNewApplicationLike(this.getApplication() != null ? this.getApplication() : item);
    }

    @Override
    public A withServices(Service ... services) {
        if (this.services != null) {
            this.services.clear();
        }
        if (services != null) {
            for (Service item : services) {
                this.addToServices(item);
            }
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public Service[] getServices() {
        int size = this.services != null ? this.services.size() : 0;
        Service[] result = new Service[size];
        if (size == 0) {
            return result;
        }
        int index = 0;
        for (VisitableBuilder visitableBuilder : this.services) {
            result[index++] = (Service)visitableBuilder.build();
        }
        return result;
    }

    @Override
    public Service[] buildServices() {
        int size = this.services != null ? this.services.size() : 0;
        Service[] result = new Service[size];
        if (size == 0) {
            return result;
        }
        int index = 0;
        for (VisitableBuilder visitableBuilder : this.services) {
            result[index++] = (Service)visitableBuilder.build();
        }
        return result;
    }

    @Override
    public Service buildService(Integer index) {
        return this.services.get(index).build();
    }

    @Override
    public Service buildFirstService() {
        return this.services.get(0).build();
    }

    @Override
    public Service buildLastService() {
        return this.services.get(this.services.size() - 1).build();
    }

    @Override
    public Service buildMatchingService(Predicate<ServiceBuilder> predicate) {
        for (ServiceBuilder item : this.services) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingService(Predicate<ServiceBuilder> predicate) {
        for (ServiceBuilder item : this.services) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A addToServices(Integer index, Service item) {
        if (this.services == null) {
            this.services = new ArrayList();
        }
        ServiceBuilder builder = new ServiceBuilder(item);
        this._visitables.get((Object)"services").add(index >= 0 ? index.intValue() : this._visitables.get((Object)"services").size(), builder);
        this.services.add(index >= 0 ? index.intValue() : this.services.size(), builder);
        return (A)this;
    }

    @Override
    public A setToServices(Integer index, Service item) {
        if (this.services == null) {
            this.services = new ArrayList();
        }
        ServiceBuilder builder = new ServiceBuilder(item);
        if (index < 0 || index >= this._visitables.get((Object)"services").size()) {
            this._visitables.get((Object)"services").add(builder);
        } else {
            this._visitables.get((Object)"services").set(index, builder);
        }
        if (index < 0 || index >= this.services.size()) {
            this.services.add(builder);
        } else {
            this.services.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToServices(Service ... items) {
        if (this.services == null) {
            this.services = new ArrayList();
        }
        for (Service item : items) {
            ServiceBuilder builder = new ServiceBuilder(item);
            this._visitables.get((Object)"services").add(builder);
            this.services.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToServices(Collection<Service> items) {
        if (this.services == null) {
            this.services = new ArrayList();
        }
        for (Service item : items) {
            ServiceBuilder builder = new ServiceBuilder(item);
            this._visitables.get((Object)"services").add(builder);
            this.services.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromServices(Service ... items) {
        for (Service item : items) {
            ServiceBuilder builder = new ServiceBuilder(item);
            this._visitables.get((Object)"services").remove(builder);
            if (this.services == null) continue;
            this.services.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromServices(Collection<Service> items) {
        for (Service item : items) {
            ServiceBuilder builder = new ServiceBuilder(item);
            this._visitables.get((Object)"services").remove(builder);
            if (this.services == null) continue;
            this.services.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromServices(Predicate<ServiceBuilder> predicate) {
        if (this.services == null) {
            return (A)this;
        }
        Iterator<ServiceBuilder> each = this.services.iterator();
        List visitables = this._visitables.get((Object)"services");
        while (each.hasNext()) {
            ServiceBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    public Boolean hasServices() {
        return this.services != null && !this.services.isEmpty();
    }

    @Override
    public ServiceBindingSpecFluent.ServicesNested<A> addNewService() {
        return new ServicesNestedImpl();
    }

    @Override
    public ServiceBindingSpecFluent.ServicesNested<A> addNewServiceLike(Service item) {
        return new ServicesNestedImpl(-1, item);
    }

    @Override
    public ServiceBindingSpecFluent.ServicesNested<A> setNewServiceLike(Integer index, Service item) {
        return new ServicesNestedImpl(index, item);
    }

    @Override
    public ServiceBindingSpecFluent.ServicesNested<A> editService(Integer index) {
        if (this.services.size() <= index) {
            throw new RuntimeException("Can't edit services. Index exceeds size.");
        }
        return this.setNewServiceLike(index, this.buildService(index));
    }

    @Override
    public ServiceBindingSpecFluent.ServicesNested<A> editFirstService() {
        if (this.services.size() == 0) {
            throw new RuntimeException("Can't edit first services. The list is empty.");
        }
        return this.setNewServiceLike(0, this.buildService(0));
    }

    @Override
    public ServiceBindingSpecFluent.ServicesNested<A> editLastService() {
        int index = this.services.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last services. The list is empty.");
        }
        return this.setNewServiceLike(index, this.buildService(index));
    }

    @Override
    public ServiceBindingSpecFluent.ServicesNested<A> editMatchingService(Predicate<ServiceBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.services.size(); ++i) {
            if (!predicate.test(this.services.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching services. No match found.");
        }
        return this.setNewServiceLike(index, this.buildService(index));
    }

    @Override
    public String getEnvVarPrefix() {
        return this.envVarPrefix;
    }

    @Override
    public A withEnvVarPrefix(String envVarPrefix) {
        this.envVarPrefix = envVarPrefix;
        return (A)this;
    }

    @Override
    public Boolean hasEnvVarPrefix() {
        return this.envVarPrefix != null;
    }

    @Override
    public boolean isDetectBindingResources() {
        return this.detectBindingResources;
    }

    @Override
    public A withDetectBindingResources(boolean detectBindingResources) {
        this.detectBindingResources = detectBindingResources;
        return (A)this;
    }

    @Override
    public Boolean hasDetectBindingResources() {
        return true;
    }

    @Override
    public boolean isBindAsFiles() {
        return this.bindAsFiles;
    }

    @Override
    public A withBindAsFiles(boolean bindAsFiles) {
        this.bindAsFiles = bindAsFiles;
        return (A)this;
    }

    @Override
    public Boolean hasBindAsFiles() {
        return true;
    }

    @Override
    public String getMountPath() {
        return this.mountPath;
    }

    @Override
    public A withMountPath(String mountPath) {
        this.mountPath = mountPath;
        return (A)this;
    }

    @Override
    public Boolean hasMountPath() {
        return this.mountPath != null;
    }

    @Override
    public A withCustomEnvVar(CustomEnvVar ... customEnvVar) {
        if (this.customEnvVar != null) {
            this.customEnvVar.clear();
        }
        if (customEnvVar != null) {
            for (CustomEnvVar item : customEnvVar) {
                this.addToCustomEnvVar(item);
            }
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public CustomEnvVar[] getCustomEnvVar() {
        int size = this.customEnvVar != null ? this.customEnvVar.size() : 0;
        CustomEnvVar[] result = new CustomEnvVar[size];
        if (size == 0) {
            return result;
        }
        int index = 0;
        for (VisitableBuilder visitableBuilder : this.customEnvVar) {
            result[index++] = (CustomEnvVar)visitableBuilder.build();
        }
        return result;
    }

    @Override
    public CustomEnvVar[] buildCustomEnvVar() {
        int size = this.customEnvVar != null ? this.customEnvVar.size() : 0;
        CustomEnvVar[] result = new CustomEnvVar[size];
        if (size == 0) {
            return result;
        }
        int index = 0;
        for (VisitableBuilder visitableBuilder : this.customEnvVar) {
            result[index++] = (CustomEnvVar)visitableBuilder.build();
        }
        return result;
    }

    @Override
    public CustomEnvVar buildCustomEnvVar(Integer index) {
        return this.customEnvVar.get(index).build();
    }

    @Override
    public CustomEnvVar buildFirstCustomEnvVar() {
        return this.customEnvVar.get(0).build();
    }

    @Override
    public CustomEnvVar buildLastCustomEnvVar() {
        return this.customEnvVar.get(this.customEnvVar.size() - 1).build();
    }

    @Override
    public CustomEnvVar buildMatchingCustomEnvVar(Predicate<CustomEnvVarBuilder> predicate) {
        for (CustomEnvVarBuilder item : this.customEnvVar) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingCustomEnvVar(Predicate<CustomEnvVarBuilder> predicate) {
        for (CustomEnvVarBuilder item : this.customEnvVar) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A addToCustomEnvVar(Integer index, CustomEnvVar item) {
        if (this.customEnvVar == null) {
            this.customEnvVar = new ArrayList();
        }
        CustomEnvVarBuilder builder = new CustomEnvVarBuilder(item);
        this._visitables.get((Object)"customEnvVar").add(index >= 0 ? index.intValue() : this._visitables.get((Object)"customEnvVar").size(), builder);
        this.customEnvVar.add(index >= 0 ? index.intValue() : this.customEnvVar.size(), builder);
        return (A)this;
    }

    @Override
    public A setToCustomEnvVar(Integer index, CustomEnvVar item) {
        if (this.customEnvVar == null) {
            this.customEnvVar = new ArrayList();
        }
        CustomEnvVarBuilder builder = new CustomEnvVarBuilder(item);
        if (index < 0 || index >= this._visitables.get((Object)"customEnvVar").size()) {
            this._visitables.get((Object)"customEnvVar").add(builder);
        } else {
            this._visitables.get((Object)"customEnvVar").set(index, builder);
        }
        if (index < 0 || index >= this.customEnvVar.size()) {
            this.customEnvVar.add(builder);
        } else {
            this.customEnvVar.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToCustomEnvVar(CustomEnvVar ... items) {
        if (this.customEnvVar == null) {
            this.customEnvVar = new ArrayList();
        }
        for (CustomEnvVar item : items) {
            CustomEnvVarBuilder builder = new CustomEnvVarBuilder(item);
            this._visitables.get((Object)"customEnvVar").add(builder);
            this.customEnvVar.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToCustomEnvVar(Collection<CustomEnvVar> items) {
        if (this.customEnvVar == null) {
            this.customEnvVar = new ArrayList();
        }
        for (CustomEnvVar item : items) {
            CustomEnvVarBuilder builder = new CustomEnvVarBuilder(item);
            this._visitables.get((Object)"customEnvVar").add(builder);
            this.customEnvVar.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromCustomEnvVar(CustomEnvVar ... items) {
        for (CustomEnvVar item : items) {
            CustomEnvVarBuilder builder = new CustomEnvVarBuilder(item);
            this._visitables.get((Object)"customEnvVar").remove(builder);
            if (this.customEnvVar == null) continue;
            this.customEnvVar.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromCustomEnvVar(Collection<CustomEnvVar> items) {
        for (CustomEnvVar item : items) {
            CustomEnvVarBuilder builder = new CustomEnvVarBuilder(item);
            this._visitables.get((Object)"customEnvVar").remove(builder);
            if (this.customEnvVar == null) continue;
            this.customEnvVar.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromCustomEnvVar(Predicate<CustomEnvVarBuilder> predicate) {
        if (this.customEnvVar == null) {
            return (A)this;
        }
        Iterator<CustomEnvVarBuilder> each = this.customEnvVar.iterator();
        List visitables = this._visitables.get((Object)"customEnvVar");
        while (each.hasNext()) {
            CustomEnvVarBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    public Boolean hasCustomEnvVar() {
        return this.customEnvVar != null && !this.customEnvVar.isEmpty();
    }

    @Override
    public ServiceBindingSpecFluent.CustomEnvVarNested<A> addNewCustomEnvVar() {
        return new CustomEnvVarNestedImpl();
    }

    @Override
    public ServiceBindingSpecFluent.CustomEnvVarNested<A> addNewCustomEnvVarLike(CustomEnvVar item) {
        return new CustomEnvVarNestedImpl(-1, item);
    }

    @Override
    public ServiceBindingSpecFluent.CustomEnvVarNested<A> setNewCustomEnvVarLike(Integer index, CustomEnvVar item) {
        return new CustomEnvVarNestedImpl(index, item);
    }

    @Override
    public ServiceBindingSpecFluent.CustomEnvVarNested<A> editCustomEnvVar(Integer index) {
        if (this.customEnvVar.size() <= index) {
            throw new RuntimeException("Can't edit customEnvVar. Index exceeds size.");
        }
        return this.setNewCustomEnvVarLike(index, this.buildCustomEnvVar(index));
    }

    @Override
    public ServiceBindingSpecFluent.CustomEnvVarNested<A> editFirstCustomEnvVar() {
        if (this.customEnvVar.size() == 0) {
            throw new RuntimeException("Can't edit first customEnvVar. The list is empty.");
        }
        return this.setNewCustomEnvVarLike(0, this.buildCustomEnvVar(0));
    }

    @Override
    public ServiceBindingSpecFluent.CustomEnvVarNested<A> editLastCustomEnvVar() {
        int index = this.customEnvVar.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last customEnvVar. The list is empty.");
        }
        return this.setNewCustomEnvVarLike(index, this.buildCustomEnvVar(index));
    }

    @Override
    public ServiceBindingSpecFluent.CustomEnvVarNested<A> editMatchingCustomEnvVar(Predicate<CustomEnvVarBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.customEnvVar.size(); ++i) {
            if (!predicate.test(this.customEnvVar.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching customEnvVar. No match found.");
        }
        return this.setNewCustomEnvVarLike(index, this.buildCustomEnvVar(index));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ServiceBindingSpecFluentImpl that = (ServiceBindingSpecFluentImpl)o;
        if (this.application != null ? !this.application.equals(that.application) : that.application != null) {
            return false;
        }
        if (this.services != null ? !this.services.equals(that.services) : that.services != null) {
            return false;
        }
        if (this.envVarPrefix != null ? !this.envVarPrefix.equals(that.envVarPrefix) : that.envVarPrefix != null) {
            return false;
        }
        if (this.detectBindingResources != that.detectBindingResources) {
            return false;
        }
        if (this.bindAsFiles != that.bindAsFiles) {
            return false;
        }
        if (this.mountPath != null ? !this.mountPath.equals(that.mountPath) : that.mountPath != null) {
            return false;
        }
        return !(this.customEnvVar != null ? !this.customEnvVar.equals(that.customEnvVar) : that.customEnvVar != null);
    }

    public int hashCode() {
        return Objects.hash(this.application, this.services, this.envVarPrefix, this.detectBindingResources, this.bindAsFiles, this.mountPath, this.customEnvVar, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.application != null) {
            sb.append("application:");
            sb.append(this.application + ",");
        }
        if (this.services != null && !this.services.isEmpty()) {
            sb.append("services:");
            sb.append(this.services + ",");
        }
        if (this.envVarPrefix != null) {
            sb.append("envVarPrefix:");
            sb.append(this.envVarPrefix + ",");
        }
        sb.append("detectBindingResources:");
        sb.append(this.detectBindingResources + ",");
        sb.append("bindAsFiles:");
        sb.append(this.bindAsFiles + ",");
        if (this.mountPath != null) {
            sb.append("mountPath:");
            sb.append(this.mountPath + ",");
        }
        if (this.customEnvVar != null && !this.customEnvVar.isEmpty()) {
            sb.append("customEnvVar:");
            sb.append(this.customEnvVar);
        }
        sb.append("}");
        return sb.toString();
    }

    @Override
    public A withDetectBindingResources() {
        return this.withDetectBindingResources(true);
    }

    @Override
    public A withBindAsFiles() {
        return this.withBindAsFiles(true);
    }

    class CustomEnvVarNestedImpl<N>
    extends CustomEnvVarFluentImpl<ServiceBindingSpecFluent.CustomEnvVarNested<N>>
    implements ServiceBindingSpecFluent.CustomEnvVarNested<N>,
    Nested<N> {
        CustomEnvVarBuilder builder;
        Integer index;

        CustomEnvVarNestedImpl(Integer index, CustomEnvVar item) {
            this.index = index;
            this.builder = new CustomEnvVarBuilder(this, item);
        }

        CustomEnvVarNestedImpl() {
            this.index = -1;
            this.builder = new CustomEnvVarBuilder(this);
        }

        @Override
        public N and() {
            return (N)ServiceBindingSpecFluentImpl.this.setToCustomEnvVar(this.index, this.builder.build());
        }

        @Override
        public N endCustomEnvVar() {
            return this.and();
        }
    }

    class ServicesNestedImpl<N>
    extends ServiceFluentImpl<ServiceBindingSpecFluent.ServicesNested<N>>
    implements ServiceBindingSpecFluent.ServicesNested<N>,
    Nested<N> {
        ServiceBuilder builder;
        Integer index;

        ServicesNestedImpl(Integer index, Service item) {
            this.index = index;
            this.builder = new ServiceBuilder(this, item);
        }

        ServicesNestedImpl() {
            this.index = -1;
            this.builder = new ServiceBuilder(this);
        }

        @Override
        public N and() {
            return (N)ServiceBindingSpecFluentImpl.this.setToServices(this.index, this.builder.build());
        }

        @Override
        public N endService() {
            return this.and();
        }
    }

    class ApplicationNestedImpl<N>
    extends ApplicationFluentImpl<ServiceBindingSpecFluent.ApplicationNested<N>>
    implements ServiceBindingSpecFluent.ApplicationNested<N>,
    Nested<N> {
        ApplicationBuilder builder;

        ApplicationNestedImpl(Application item) {
            this.builder = new ApplicationBuilder(this, item);
        }

        ApplicationNestedImpl() {
            this.builder = new ApplicationBuilder(this);
        }

        @Override
        public N and() {
            return (N)ServiceBindingSpecFluentImpl.this.withApplication(this.builder.build());
        }

        @Override
        public N endApplication() {
            return this.and();
        }
    }
}

