/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.servicebinding.adapter;

import io.dekorate.kubernetes.config.Env;
import io.dekorate.servicebinding.annotation.Application;
import io.dekorate.servicebinding.annotation.BindingPath;
import io.dekorate.servicebinding.annotation.ServiceBinding;
import io.dekorate.servicebinding.config.ApplicationConfig;
import io.dekorate.servicebinding.config.ApplicationConfigBuilder;
import io.dekorate.servicebinding.config.BindingPathConfig;
import io.dekorate.servicebinding.config.ServiceBindingConfig;
import io.dekorate.servicebinding.config.ServiceBindingConfigBuilder;
import io.dekorate.servicebinding.config.ServiceConfig;
import io.dekorate.servicebinding.config.ServiceConfigBuilder;
import java.util.Arrays;
import java.util.Map;

public class ServiceBindingConfigAdapter {
    public static ServiceBindingConfig adapt(ServiceBinding instance) {
        return ServiceBindingConfigAdapter.newBuilder(instance).build();
    }

    public static ServiceBindingConfigBuilder newBuilder(ServiceBinding instance) {
        Application app = instance.application();
        BindingPath bindingPath = instance.bindingPath();
        return new ServiceBindingConfigBuilder(new ServiceBindingConfig(null, null, null, instance.name(), null, ((ApplicationConfigBuilder)((ApplicationConfigBuilder)((ApplicationConfigBuilder)((ApplicationConfigBuilder)((ApplicationConfigBuilder)new ApplicationConfigBuilder().withResource(app.resource())).withKind(app.kind())).withGroup(app.group())).withVersion(app.version())).withName(app.name())).build(), (ServiceConfig[])Arrays.stream(instance.services()).map(s -> new ServiceConfig(null, null, s.group(), s.kind(), s.name(), s.version(), s.id(), s.namespace(), s.envVarPrefix())).toArray(ServiceConfig[]::new), instance.envVarPrefix(), instance.detectBindingResources(), instance.bindAsFiles(), instance.mountPath(), (Env[])Arrays.stream(instance.customEnvVar()).map(c -> new Env(c.name(), c.value(), c.secret(), c.configmap(), c.field(), c.resourceField())).toArray(Env[]::new), new BindingPathConfig(null, null, bindingPath.containerPath(), bindingPath.secretPath())));
    }

    public static ServiceBindingConfig adapt(Map map) {
        return ServiceBindingConfigAdapter.getServiceBindingConfig(map);
    }

    private static ServiceBindingConfig getServiceBindingConfig(Map map) {
        return new ServiceBindingConfig(null, null, null, map.getOrDefault("name", ""), null, ServiceBindingConfigAdapter.getApplicationConfig((Map)map.get("application")), (ServiceConfig[])Arrays.stream(map.getOrDefault("services", new Map[0])).map(ServiceBindingConfigAdapter::getServiceConfig).toArray(ServiceConfig[]::new), map.getOrDefault("envVarPrefix", ""), Boolean.parseBoolean(String.valueOf(map.getOrDefault("detectBindingResources", "false"))), Boolean.parseBoolean(String.valueOf(map.getOrDefault("bindAsFiles", "false"))), map.getOrDefault("mountPath", ""), (Env[])Arrays.stream(map.getOrDefault("customEnvVar", new Map[0])).map(ServiceBindingConfigAdapter::getCustomEnvVarConfig).toArray(Env[]::new), ServiceBindingConfigAdapter.getBindingPathConfig((Map)map.get("bindingPath")));
    }

    public static ServiceBindingConfigBuilder newBuilder(Map map) {
        return new ServiceBindingConfigBuilder(ServiceBindingConfigAdapter.getServiceBindingConfig(map));
    }

    private static ApplicationConfig getApplicationConfig(Map i) {
        if (i == null) {
            return null;
        }
        return ((ApplicationConfigBuilder)((ApplicationConfigBuilder)((ApplicationConfigBuilder)((ApplicationConfigBuilder)((ApplicationConfigBuilder)new ApplicationConfigBuilder().withResource(i.getOrDefault("resource", null))).withKind(i.getOrDefault("kind", null))).withGroup(i.getOrDefault("group", null))).withVersion(i.getOrDefault("version", null))).withName(i.getOrDefault("name", null))).build();
    }

    private static ServiceConfig getServiceConfig(Map i) {
        String apiVersion = i.getOrDefault("apiVersion", null);
        String apiVersionGroup = apiVersion != null && apiVersion.contains("/") ? apiVersion.split("/")[0] : "";
        String apiVersionVersion = apiVersion != null && apiVersion.contains("/") ? apiVersion.split("/")[1] : apiVersion;
        return ((ServiceConfigBuilder)((ServiceConfigBuilder)((ServiceConfigBuilder)((ServiceConfigBuilder)((ServiceConfigBuilder)((ServiceConfigBuilder)((ServiceConfigBuilder)new ServiceConfigBuilder().withKind(i.getOrDefault("kind", null))).withGroup(i.getOrDefault("group", apiVersionGroup))).withVersion(i.getOrDefault("version", apiVersionVersion))).withName(i.getOrDefault("name", null))).withNamespace(i.getOrDefault("namespace", null))).withId(i.getOrDefault("id", null))).withEnvVarPrefix(i.getOrDefault("envVarPrefix", null))).build();
    }

    private static Env getCustomEnvVarConfig(Map i) {
        return new Env((String)i.getOrDefault("name", null), (String)i.getOrDefault("value", null), (String)i.getOrDefault("secret", null), (String)i.getOrDefault("configmap", null), (String)i.getOrDefault("field", null), (String)i.getOrDefault("resourceField", null));
    }

    private static BindingPathConfig getBindingPathConfig(Map i) {
        if (i == null) {
            return null;
        }
        return new BindingPathConfig(null, null, i.getOrDefault("containerPath", null), i.getOrDefault("secretPath", null));
    }
}

