/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.servicebinding.model;

import io.dekorate.servicebinding.model.ServiceBinding;
import io.dekorate.servicebinding.model.ServiceBindingSpec;
import io.dekorate.servicebinding.model.ServiceBindingSpecBuilder;
import io.dekorate.servicebinding.model.ServiceBindingSpecFluent;
import io.dekorate.servicebinding.model.ServiceBindingStatus;
import io.dekorate.servicebinding.model.ServiceBindingStatusBuilder;
import io.dekorate.servicebinding.model.ServiceBindingStatusFluent;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import java.util.Objects;
import java.util.Optional;

public class ServiceBindingFluent<A extends ServiceBindingFluent<A>>
extends BaseFluent<A> {
    private String kind;
    private String apiVersion;
    private ObjectMetaBuilder metadata;
    private ServiceBindingSpecBuilder spec;
    private ServiceBindingStatusBuilder status;

    public ServiceBindingFluent() {
    }

    public ServiceBindingFluent(ServiceBinding instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(ServiceBinding instance) {
        ServiceBinding serviceBinding = instance = instance != null ? instance : new ServiceBinding();
        if (instance != null) {
            this.withKind(instance.getKind());
            this.withApiVersion(instance.getApiVersion());
            this.withMetadata(instance.getMetadata());
            this.withSpec(instance.getSpec());
            this.withStatus(instance.getStatus());
        }
    }

    public String getKind() {
        return this.kind;
    }

    public A withKind(String kind) {
        this.kind = kind;
        return (A)((Object)this);
    }

    public boolean hasKind() {
        return this.kind != null;
    }

    public String getApiVersion() {
        return this.apiVersion;
    }

    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)((Object)this);
    }

    public boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    public ObjectMeta buildMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    public A withMetadata(ObjectMeta metadata) {
        this._visitables.remove((Object)"metadata");
        if (metadata != null) {
            this.metadata = new ObjectMetaBuilder(metadata);
            this._visitables.get((Object)"metadata").add(this.metadata);
        } else {
            this.metadata = null;
            this._visitables.get((Object)"metadata").remove(this.metadata);
        }
        return (A)((Object)this);
    }

    public boolean hasMetadata() {
        return this.metadata != null;
    }

    public MetadataNested<A> withNewMetadata() {
        return new MetadataNested(null);
    }

    public MetadataNested<A> withNewMetadataLike(ObjectMeta item) {
        return new MetadataNested(item);
    }

    public MetadataNested<A> editMetadata() {
        return this.withNewMetadataLike(Optional.ofNullable(this.buildMetadata()).orElse(null));
    }

    public MetadataNested<A> editOrNewMetadata() {
        return this.withNewMetadataLike(Optional.ofNullable(this.buildMetadata()).orElse(new ObjectMetaBuilder().build()));
    }

    public MetadataNested<A> editOrNewMetadataLike(ObjectMeta item) {
        return this.withNewMetadataLike(Optional.ofNullable(this.buildMetadata()).orElse(item));
    }

    public ServiceBindingSpec buildSpec() {
        return this.spec != null ? this.spec.build() : null;
    }

    public A withSpec(ServiceBindingSpec spec) {
        this._visitables.remove((Object)"spec");
        if (spec != null) {
            this.spec = new ServiceBindingSpecBuilder(spec);
            this._visitables.get((Object)"spec").add(this.spec);
        } else {
            this.spec = null;
            this._visitables.get((Object)"spec").remove((Object)this.spec);
        }
        return (A)((Object)this);
    }

    public boolean hasSpec() {
        return this.spec != null;
    }

    public SpecNested<A> withNewSpec() {
        return new SpecNested(null);
    }

    public SpecNested<A> withNewSpecLike(ServiceBindingSpec item) {
        return new SpecNested(item);
    }

    public SpecNested<A> editSpec() {
        return this.withNewSpecLike(Optional.ofNullable(this.buildSpec()).orElse(null));
    }

    public SpecNested<A> editOrNewSpec() {
        return this.withNewSpecLike(Optional.ofNullable(this.buildSpec()).orElse(new ServiceBindingSpecBuilder().build()));
    }

    public SpecNested<A> editOrNewSpecLike(ServiceBindingSpec item) {
        return this.withNewSpecLike(Optional.ofNullable(this.buildSpec()).orElse(item));
    }

    public ServiceBindingStatus buildStatus() {
        return this.status != null ? this.status.build() : null;
    }

    public A withStatus(ServiceBindingStatus status) {
        this._visitables.remove((Object)"status");
        if (status != null) {
            this.status = new ServiceBindingStatusBuilder(status);
            this._visitables.get((Object)"status").add(this.status);
        } else {
            this.status = null;
            this._visitables.get((Object)"status").remove((Object)this.status);
        }
        return (A)((Object)this);
    }

    public boolean hasStatus() {
        return this.status != null;
    }

    public StatusNested<A> withNewStatus() {
        return new StatusNested(null);
    }

    public StatusNested<A> withNewStatusLike(ServiceBindingStatus item) {
        return new StatusNested(item);
    }

    public StatusNested<A> editStatus() {
        return this.withNewStatusLike(Optional.ofNullable(this.buildStatus()).orElse(null));
    }

    public StatusNested<A> editOrNewStatus() {
        return this.withNewStatusLike(Optional.ofNullable(this.buildStatus()).orElse(new ServiceBindingStatusBuilder().build()));
    }

    public StatusNested<A> editOrNewStatusLike(ServiceBindingStatus item) {
        return this.withNewStatusLike(Optional.ofNullable(this.buildStatus()).orElse(item));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ServiceBindingFluent that = (ServiceBindingFluent)((Object)o);
        if (!Objects.equals(this.kind, that.kind)) {
            return false;
        }
        if (!Objects.equals(this.apiVersion, that.apiVersion)) {
            return false;
        }
        if (!Objects.equals(this.metadata, that.metadata)) {
            return false;
        }
        if (!Objects.equals((Object)this.spec, (Object)that.spec)) {
            return false;
        }
        return Objects.equals((Object)this.status, (Object)that.status);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.kind, this.apiVersion, this.metadata, this.spec, this.status, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.kind != null) {
            sb.append("kind:");
            sb.append(this.kind + ",");
        }
        if (this.apiVersion != null) {
            sb.append("apiVersion:");
            sb.append(this.apiVersion + ",");
        }
        if (this.metadata != null) {
            sb.append("metadata:");
            sb.append(this.metadata + ",");
        }
        if (this.spec != null) {
            sb.append("spec:");
            sb.append((Object)((Object)this.spec) + ",");
        }
        if (this.status != null) {
            sb.append("status:");
            sb.append((Object)this.status);
        }
        sb.append("}");
        return sb.toString();
    }

    public class StatusNested<N>
    extends ServiceBindingStatusFluent<StatusNested<N>>
    implements Nested<N> {
        ServiceBindingStatusBuilder builder;

        StatusNested(ServiceBindingStatus item) {
            this.builder = new ServiceBindingStatusBuilder(this, item);
        }

        public N and() {
            return (N)ServiceBindingFluent.this.withStatus(this.builder.build());
        }

        public N endStatus() {
            return this.and();
        }
    }

    public class SpecNested<N>
    extends ServiceBindingSpecFluent<SpecNested<N>>
    implements Nested<N> {
        ServiceBindingSpecBuilder builder;

        SpecNested(ServiceBindingSpec item) {
            this.builder = new ServiceBindingSpecBuilder(this, item);
        }

        public N and() {
            return (N)ServiceBindingFluent.this.withSpec(this.builder.build());
        }

        public N endSpec() {
            return this.and();
        }
    }

    public class MetadataNested<N>
    extends ObjectMetaFluent<MetadataNested<N>>
    implements Nested<N> {
        ObjectMetaBuilder builder;

        MetadataNested(ObjectMeta item) {
            this.builder = new ObjectMetaBuilder((ObjectMetaFluent)this, item);
        }

        public N and() {
            return (N)ServiceBindingFluent.this.withMetadata(this.builder.build());
        }

        public N endMetadata() {
            return this.and();
        }
    }
}

