package io.dekorate.servicebinding.config;

import io.dekorate.project.Project;
import io.dekorate.kubernetes.config.ConfigKey;
import io.dekorate.kubernetes.config.Configuration;
import java.lang.Object;
import java.lang.String;
import java.util.Map;
import io.sundr.builder.annotations.Buildable;

/**
 * Generated
 */
@Buildable(refs = {@io.sundr.builder.annotations.BuildableReference(io.dekorate.project.Project.class),@io.sundr.builder.annotations.BuildableReference(io.dekorate.project.BuildInfo.class)} ,builderPackage = "io.fabric8.kubernetes.api.builder")
public class ApplicationConfig extends Configuration{
  public ApplicationConfig() {
  }
  
  public ApplicationConfig(Project project,Map<ConfigKey,Object> attributes,String resource,String kind,String name,String group,String version) {
    super(project, attributes);
    this.resource = resource;
    this.kind = kind;
    this.name = name;
    this.group = group;
    this.version = version;
  }
  private String resource;
  private String kind;
  private String name;
  private String group;
  private String version;
  
  public String getResource() {
    return this.resource;
  }
  
  public String getKind() {
    return this.kind;
  }
  
  public String getName() {
    return this.name;
  }
  
  public String getGroup() {
    return this.group;
  }
  
  public String getVersion() {
    return this.version;
  }
  
  public static ApplicationConfigBuilder newApplicationConfigBuilder() {
    return new ApplicationConfigBuilder();
  }
  
  public static ApplicationConfigBuilder newApplicationConfigBuilderFromDefaults() {
    return new ApplicationConfigBuilder();
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ApplicationConfig that = (ApplicationConfig) o;
    if (!java.util.Objects.equals(resource, that.resource)) return false;
    if (!java.util.Objects.equals(kind, that.kind)) return false;
    if (!java.util.Objects.equals(name, that.name)) return false;
    if (!java.util.Objects.equals(group, that.group)) return false;
    if (!java.util.Objects.equals(version, that.version)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(resource,  kind,  name,  group,  version,  super.hashCode());
  }
  

}