package io.dekorate.servicebinding.config;

import java.lang.SuppressWarnings;
import java.lang.Object;
import io.dekorate.kubernetes.config.ConfigurationFluent;
import java.lang.String;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class ApplicationConfigFluent<A extends ApplicationConfigFluent<A>> extends ConfigurationFluent<A>{
  public ApplicationConfigFluent() {
  }
  
  public ApplicationConfigFluent(ApplicationConfig instance) {
    this.copyInstance(instance);
  }
  private String resource;
  private String kind;
  private String name;
  private String group;
  private String version;
  
  protected void copyInstance(ApplicationConfig instance) {
    instance = (instance != null ? instance : new ApplicationConfig());
    if (instance != null) {
          this.withProject(instance.getProject());
          this.withAttributes(instance.getAttributes());
          this.withResource(instance.getResource());
          this.withKind(instance.getKind());
          this.withName(instance.getName());
          this.withGroup(instance.getGroup());
          this.withVersion(instance.getVersion());
        }
  }
  
  public String getResource() {
    return this.resource;
  }
  
  public A withResource(String resource) {
    this.resource = resource;
    return (A) this;
  }
  
  public boolean hasResource() {
    return this.resource != null;
  }
  
  public String getKind() {
    return this.kind;
  }
  
  public A withKind(String kind) {
    this.kind = kind;
    return (A) this;
  }
  
  public boolean hasKind() {
    return this.kind != null;
  }
  
  public String getName() {
    return this.name;
  }
  
  public A withName(String name) {
    this.name = name;
    return (A) this;
  }
  
  public boolean hasName() {
    return this.name != null;
  }
  
  public String getGroup() {
    return this.group;
  }
  
  public A withGroup(String group) {
    this.group = group;
    return (A) this;
  }
  
  public boolean hasGroup() {
    return this.group != null;
  }
  
  public String getVersion() {
    return this.version;
  }
  
  public A withVersion(String version) {
    this.version = version;
    return (A) this;
  }
  
  public boolean hasVersion() {
    return this.version != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ApplicationConfigFluent that = (ApplicationConfigFluent) o;
    if (!java.util.Objects.equals(resource, that.resource)) return false;
    if (!java.util.Objects.equals(kind, that.kind)) return false;
    if (!java.util.Objects.equals(name, that.name)) return false;
    if (!java.util.Objects.equals(group, that.group)) return false;
    if (!java.util.Objects.equals(version, that.version)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(resource,  kind,  name,  group,  version,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (resource != null) { sb.append("resource:"); sb.append(resource + ","); }
    if (kind != null) { sb.append("kind:"); sb.append(kind + ","); }
    if (name != null) { sb.append("name:"); sb.append(name + ","); }
    if (group != null) { sb.append("group:"); sb.append(group + ","); }
    if (version != null) { sb.append("version:"); sb.append(version); }
    sb.append("}");
    return sb.toString();
  }
  

}