package io.dekorate.servicebinding.config;

import io.dekorate.project.Project;
import io.dekorate.kubernetes.config.ConfigKey;
import io.dekorate.kubernetes.config.Configuration;
import java.lang.Object;
import java.lang.String;
import java.util.Map;
import io.sundr.builder.annotations.Buildable;

/**
 * Generated
 */
@Buildable(refs = {@io.sundr.builder.annotations.BuildableReference(io.dekorate.project.Project.class),@io.sundr.builder.annotations.BuildableReference(io.dekorate.project.BuildInfo.class)} ,builderPackage = "io.fabric8.kubernetes.api.builder")
public class BindingPathConfig extends Configuration{
  public BindingPathConfig() {
  }
  
  public BindingPathConfig(Project project,Map<ConfigKey,Object> attributes,String containerPath,String secretPath) {
    super(project, attributes);
    this.containerPath = containerPath;
    this.secretPath = secretPath;
  }
  private String containerPath;
  private String secretPath;
  
  public String getContainerPath() {
    return this.containerPath;
  }
  
  public String getSecretPath() {
    return this.secretPath;
  }
  
  public static BindingPathConfigBuilder newBindingPathConfigBuilder() {
    return new BindingPathConfigBuilder();
  }
  
  public static BindingPathConfigBuilder newBindingPathConfigBuilderFromDefaults() {
    return new BindingPathConfigBuilder();
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    BindingPathConfig that = (BindingPathConfig) o;
    if (!java.util.Objects.equals(containerPath, that.containerPath)) return false;
    if (!java.util.Objects.equals(secretPath, that.secretPath)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(containerPath,  secretPath,  super.hashCode());
  }
  

}