package io.dekorate.servicebinding.config;

import java.lang.SuppressWarnings;
import java.lang.Object;
import io.dekorate.kubernetes.config.ConfigurationFluent;
import java.lang.String;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class BindingPathConfigFluent<A extends BindingPathConfigFluent<A>> extends ConfigurationFluent<A>{
  public BindingPathConfigFluent() {
  }
  
  public BindingPathConfigFluent(BindingPathConfig instance) {
    this.copyInstance(instance);
  }
  private String containerPath;
  private String secretPath;
  
  protected void copyInstance(BindingPathConfig instance) {
    instance = (instance != null ? instance : new BindingPathConfig());
    if (instance != null) {
          this.withProject(instance.getProject());
          this.withAttributes(instance.getAttributes());
          this.withContainerPath(instance.getContainerPath());
          this.withSecretPath(instance.getSecretPath());
        }
  }
  
  public String getContainerPath() {
    return this.containerPath;
  }
  
  public A withContainerPath(String containerPath) {
    this.containerPath = containerPath;
    return (A) this;
  }
  
  public boolean hasContainerPath() {
    return this.containerPath != null;
  }
  
  public String getSecretPath() {
    return this.secretPath;
  }
  
  public A withSecretPath(String secretPath) {
    this.secretPath = secretPath;
    return (A) this;
  }
  
  public boolean hasSecretPath() {
    return this.secretPath != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    BindingPathConfigFluent that = (BindingPathConfigFluent) o;
    if (!java.util.Objects.equals(containerPath, that.containerPath)) return false;
    if (!java.util.Objects.equals(secretPath, that.secretPath)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(containerPath,  secretPath,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (containerPath != null) { sb.append("containerPath:"); sb.append(containerPath + ","); }
    if (secretPath != null) { sb.append("secretPath:"); sb.append(secretPath); }
    sb.append("}");
    return sb.toString();
  }
  

}