package io.dekorate.servicebinding.config;

import io.dekorate.kubernetes.config.ConfigKey;
import java.lang.String;
import io.dekorate.kubernetes.config.Env;
import io.dekorate.project.Project;
import java.lang.Object;
import java.lang.Boolean;
import io.dekorate.kubernetes.config.ApplicationConfiguration;
import java.util.Map;
import io.sundr.builder.annotations.Buildable;

/**
 * Generated
 */
@Buildable(refs = {@io.sundr.builder.annotations.BuildableReference(io.dekorate.project.Project.class),@io.sundr.builder.annotations.BuildableReference(io.dekorate.project.BuildInfo.class)} ,builderPackage = "io.fabric8.kubernetes.api.builder")
public class ServiceBindingConfig extends ApplicationConfiguration{
  public ServiceBindingConfig() {
  }
  
  public ServiceBindingConfig(Project project,Map<ConfigKey,Object> attributes,String partOf,String name,String version,ApplicationConfig application,ServiceConfig[] services,String envVarPrefix,Boolean detectBindingResources,Boolean bindAsFiles,String mountPath,Env[] customEnvVar,BindingPathConfig bindingPath) {
    super(project, attributes, partOf, name, version);
    this.application = application;
    this.services = services != null ? services : new ServiceConfig[0];
    this.envVarPrefix = envVarPrefix;
    this.detectBindingResources = detectBindingResources;
    this.bindAsFiles = bindAsFiles;
    this.mountPath = mountPath;
    this.customEnvVar = customEnvVar != null ? customEnvVar : new Env[0];
    this.bindingPath = bindingPath;
  }
  private ApplicationConfig application;
  private ServiceConfig[] services = new ServiceConfig[0];
  private String envVarPrefix;
  private Boolean detectBindingResources;
  private Boolean bindAsFiles;
  private String mountPath;
  private Env[] customEnvVar = new Env[0];
  private BindingPathConfig bindingPath;
  
  public ApplicationConfig getApplication() {
    return this.application;
  }
  
  public ServiceConfig[] getServices() {
    return this.services;
  }
  
  public String getEnvVarPrefix() {
    return this.envVarPrefix;
  }
  
  public Boolean getDetectBindingResources() {
    return this.detectBindingResources;
  }
  
  public boolean isDetectBindingResources() {
    return this.detectBindingResources != null &&  this.detectBindingResources;
  }
  
  public Boolean getBindAsFiles() {
    return this.bindAsFiles;
  }
  
  public boolean isBindAsFiles() {
    return this.bindAsFiles != null &&  this.bindAsFiles;
  }
  
  public String getMountPath() {
    return this.mountPath;
  }
  
  public Env[] getCustomEnvVar() {
    return this.customEnvVar;
  }
  
  public BindingPathConfig getBindingPath() {
    return this.bindingPath;
  }
  
  public static ServiceBindingConfigBuilder newServiceBindingConfigBuilder() {
    return new ServiceBindingConfigBuilder();
  }
  
  public static ServiceBindingConfigBuilder newServiceBindingConfigBuilderFromDefaults() {
    return new ServiceBindingConfigBuilder().withApplication(new ApplicationConfig()).withDetectBindingResources(false).withBindAsFiles(false).withBindingPath(new BindingPathConfig());
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ServiceBindingConfig that = (ServiceBindingConfig) o;
    if (!java.util.Objects.equals(application, that.application)) return false;
    if (!java.util.Objects.equals(services, that.services)) return false;
    if (!java.util.Objects.equals(envVarPrefix, that.envVarPrefix)) return false;
    if (!java.util.Objects.equals(detectBindingResources, that.detectBindingResources)) return false;
    if (!java.util.Objects.equals(bindAsFiles, that.bindAsFiles)) return false;
    if (!java.util.Objects.equals(mountPath, that.mountPath)) return false;
    if (!java.util.Objects.equals(customEnvVar, that.customEnvVar)) return false;
    if (!java.util.Objects.equals(bindingPath, that.bindingPath)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(application,  services,  envVarPrefix,  detectBindingResources,  bindAsFiles,  mountPath,  customEnvVar,  bindingPath,  super.hashCode());
  }
  

}