package io.dekorate.servicebinding.config;

import io.dekorate.kubernetes.config.ApplicationConfigurationFluent;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.dekorate.kubernetes.config.Env;
import java.util.function.Predicate;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import io.dekorate.kubernetes.config.EnvFluent;
import io.dekorate.kubernetes.config.EnvBuilder;
import java.util.Collection;
import java.lang.Object;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class ServiceBindingConfigFluent<A extends ServiceBindingConfigFluent<A>> extends ApplicationConfigurationFluent<A>{
  public ServiceBindingConfigFluent() {
  }
  
  public ServiceBindingConfigFluent(ServiceBindingConfig instance) {
    this.copyInstance(instance);
  }
  private ApplicationConfigBuilder application;
  private ArrayList<ServiceConfigBuilder> services = new ArrayList<ServiceConfigBuilder>();
  private String envVarPrefix;
  private Boolean detectBindingResources;
  private Boolean bindAsFiles;
  private String mountPath;
  private ArrayList<EnvBuilder> customEnvVar = new ArrayList<EnvBuilder>();
  private BindingPathConfigBuilder bindingPath;
  
  protected void copyInstance(ServiceBindingConfig instance) {
    instance = (instance != null ? instance : new ServiceBindingConfig());
    if (instance != null) {
          this.withProject(instance.getProject());
          this.withAttributes(instance.getAttributes());
          this.withPartOf(instance.getPartOf());
          this.withName(instance.getName());
          this.withVersion(instance.getVersion());
          this.withApplication(instance.getApplication());
          this.withServices(instance.getServices());
          this.withEnvVarPrefix(instance.getEnvVarPrefix());
          this.withDetectBindingResources(instance.getDetectBindingResources());
          this.withBindAsFiles(instance.getBindAsFiles());
          this.withMountPath(instance.getMountPath());
          this.withCustomEnvVar(instance.getCustomEnvVar());
          this.withBindingPath(instance.getBindingPath());
        }
  }
  
  public ApplicationConfig buildApplication() {
    return this.application != null ? this.application.build() : null;
  }
  
  public A withApplication(ApplicationConfig application) {
    this._visitables.remove("application");
    if (application != null) {
        this.application = new ApplicationConfigBuilder(application);
        this._visitables.get("application").add(this.application);
    } else {
        this.application = null;
        this._visitables.get("application").remove(this.application);
    }
    return (A) this;
  }
  
  public boolean hasApplication() {
    return this.application != null;
  }
  
  public ApplicationNested<A> withNewApplication() {
    return new ApplicationNested(null);
  }
  
  public ApplicationNested<A> withNewApplicationLike(ApplicationConfig item) {
    return new ApplicationNested(item);
  }
  
  public ApplicationNested<A> editApplication() {
    return withNewApplicationLike(java.util.Optional.ofNullable(buildApplication()).orElse(null));
  }
  
  public ApplicationNested<A> editOrNewApplication() {
    return withNewApplicationLike(java.util.Optional.ofNullable(buildApplication()).orElse(new ApplicationConfigBuilder().build()));
  }
  
  public ApplicationNested<A> editOrNewApplicationLike(ApplicationConfig item) {
    return withNewApplicationLike(java.util.Optional.ofNullable(buildApplication()).orElse(item));
  }
  
  public A withServices(io.dekorate.servicebinding.config.ServiceConfig... services) {
    if (this.services != null) {
        this.services.clear();
        _visitables.remove("services");
    }
    if (services != null) {
      for (ServiceConfig item : services) {
        this.addToServices(item);
      }
    }
    return (A) this;
  }
  
  public ServiceConfig[] buildServices() {
    int size = services != null ? services.size() : 0;;
    ServiceConfig[] result = new ServiceConfig[size];;
    if (size == 0) {
      return result;
    }
    int index = 0;;
    for (VisitableBuilder<ServiceConfig,ServiceConfigBuilder> item : services) {
      result[index++] = item.build();
    }
    return result;
  }
  
  public ServiceConfig buildService(int index) {
    return this.services.get(index).build();
  }
  
  public ServiceConfig buildFirstService() {
    return this.services.get(0).build();
  }
  
  public ServiceConfig buildLastService() {
    return this.services.get(services.size() - 1).build();
  }
  
  public ServiceConfig buildMatchingService(Predicate<ServiceConfigBuilder> predicate) {
      for (ServiceConfigBuilder item : services) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingService(Predicate<ServiceConfigBuilder> predicate) {
      for (ServiceConfigBuilder item : services) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A addToServices(int index,ServiceConfig item) {
    if (this.services == null) {this.services = new ArrayList<ServiceConfigBuilder>();}
    ServiceConfigBuilder builder = new ServiceConfigBuilder(item);
    if (index < 0 || index >= services.size()) { _visitables.get("services").add(builder); services.add(builder); } else { _visitables.get("services").add(index, builder); services.add(index, builder);}
    return (A)this;
  }
  
  public A setToServices(int index,ServiceConfig item) {
    if (this.services == null) {this.services = new ArrayList<ServiceConfigBuilder>();}
    ServiceConfigBuilder builder = new ServiceConfigBuilder(item);
    if (index < 0 || index >= services.size()) { _visitables.get("services").add(builder); services.add(builder); } else { _visitables.get("services").set(index, builder); services.set(index, builder);}
    return (A)this;
  }
  
  public A addToServices(io.dekorate.servicebinding.config.ServiceConfig... items) {
    if (this.services == null) {this.services = new ArrayList<ServiceConfigBuilder>();}
    for (ServiceConfig item : items) {ServiceConfigBuilder builder = new ServiceConfigBuilder(item);_visitables.get("services").add(builder);this.services.add(builder);} return (A)this;
  }
  
  public A addAllToServices(Collection<ServiceConfig> items) {
    if (this.services == null) {this.services = new ArrayList<ServiceConfigBuilder>();}
    for (ServiceConfig item : items) {ServiceConfigBuilder builder = new ServiceConfigBuilder(item);_visitables.get("services").add(builder);this.services.add(builder);} return (A)this;
  }
  
  public A removeFromServices(io.dekorate.servicebinding.config.ServiceConfig... items) {
    if (this.services == null) return (A)this;
    for (ServiceConfig item : items) {ServiceConfigBuilder builder = new ServiceConfigBuilder(item);_visitables.get("services").remove(builder); this.services.remove(builder);} return (A)this;
  }
  
  public A removeAllFromServices(Collection<ServiceConfig> items) {
    if (this.services == null) return (A)this;
    for (ServiceConfig item : items) {ServiceConfigBuilder builder = new ServiceConfigBuilder(item);_visitables.get("services").remove(builder); this.services.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromServices(Predicate<ServiceConfigBuilder> predicate) {
    if (services == null) return (A) this;
    final Iterator<ServiceConfigBuilder> each = services.iterator();
    final List visitables = _visitables.get("services");
    while (each.hasNext()) {
      ServiceConfigBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public boolean hasServices() {
    return this.services != null && !this.services.isEmpty();
  }
  
  public ServicesNested<A> addNewService() {
    return new ServicesNested(-1, null);
  }
  
  public ServicesNested<A> addNewServiceLike(ServiceConfig item) {
    return new ServicesNested(-1, item);
  }
  
  public ServicesNested<A> setNewServiceLike(int index,ServiceConfig item) {
    return new ServicesNested(index, item);
  }
  
  public ServicesNested<A> editService(int index) {
    if (services.size() <= index) throw new RuntimeException("Can't edit services. Index exceeds size.");
    return setNewServiceLike(index, buildService(index));
  }
  
  public ServicesNested<A> editFirstService() {
    if (services.size() == 0) throw new RuntimeException("Can't edit first services. The list is empty.");
    return setNewServiceLike(0, buildService(0));
  }
  
  public ServicesNested<A> editLastService() {
    int index = services.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last services. The list is empty.");
    return setNewServiceLike(index, buildService(index));
  }
  
  public ServicesNested<A> editMatchingService(Predicate<ServiceConfigBuilder> predicate) {
    int index = -1;
    for (int i=0;i<services.size();i++) { 
    if (predicate.test(services.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching services. No match found.");
    return setNewServiceLike(index, buildService(index));
  }
  
  public String getEnvVarPrefix() {
    return this.envVarPrefix;
  }
  
  public A withEnvVarPrefix(String envVarPrefix) {
    this.envVarPrefix = envVarPrefix;
    return (A) this;
  }
  
  public boolean hasEnvVarPrefix() {
    return this.envVarPrefix != null;
  }
  
  public Boolean getDetectBindingResources() {
    return this.detectBindingResources;
  }
  
  public A withDetectBindingResources(Boolean detectBindingResources) {
    this.detectBindingResources = detectBindingResources;
    return (A) this;
  }
  
  public boolean hasDetectBindingResources() {
    return this.detectBindingResources != null;
  }
  
  public Boolean getBindAsFiles() {
    return this.bindAsFiles;
  }
  
  public A withBindAsFiles(Boolean bindAsFiles) {
    this.bindAsFiles = bindAsFiles;
    return (A) this;
  }
  
  public boolean hasBindAsFiles() {
    return this.bindAsFiles != null;
  }
  
  public String getMountPath() {
    return this.mountPath;
  }
  
  public A withMountPath(String mountPath) {
    this.mountPath = mountPath;
    return (A) this;
  }
  
  public boolean hasMountPath() {
    return this.mountPath != null;
  }
  
  public A withCustomEnvVar(io.dekorate.kubernetes.config.Env... customEnvVar) {
    if (this.customEnvVar != null) {
        this.customEnvVar.clear();
        _visitables.remove("customEnvVar");
    }
    if (customEnvVar != null) {
      for (Env item : customEnvVar) {
        this.addToCustomEnvVar(item);
      }
    }
    return (A) this;
  }
  
  public Env[] buildCustomEnvVar() {
    int size = customEnvVar != null ? customEnvVar.size() : 0;;
    Env[] result = new Env[size];;
    if (size == 0) {
      return result;
    }
    int index = 0;;
    for (VisitableBuilder<Env,EnvBuilder> item : customEnvVar) {
      result[index++] = item.build();
    }
    return result;
  }
  
  public Env buildCustomEnvVar(int index) {
    return this.customEnvVar.get(index).build();
  }
  
  public Env buildFirstCustomEnvVar() {
    return this.customEnvVar.get(0).build();
  }
  
  public Env buildLastCustomEnvVar() {
    return this.customEnvVar.get(customEnvVar.size() - 1).build();
  }
  
  public Env buildMatchingCustomEnvVar(Predicate<EnvBuilder> predicate) {
      for (EnvBuilder item : customEnvVar) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingCustomEnvVar(Predicate<EnvBuilder> predicate) {
      for (EnvBuilder item : customEnvVar) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A addToCustomEnvVar(int index,Env item) {
    if (this.customEnvVar == null) {this.customEnvVar = new ArrayList<EnvBuilder>();}
    EnvBuilder builder = new EnvBuilder(item);
    if (index < 0 || index >= customEnvVar.size()) { _visitables.get("customEnvVar").add(builder); customEnvVar.add(builder); } else { _visitables.get("customEnvVar").add(index, builder); customEnvVar.add(index, builder);}
    return (A)this;
  }
  
  public A setToCustomEnvVar(int index,Env item) {
    if (this.customEnvVar == null) {this.customEnvVar = new ArrayList<EnvBuilder>();}
    EnvBuilder builder = new EnvBuilder(item);
    if (index < 0 || index >= customEnvVar.size()) { _visitables.get("customEnvVar").add(builder); customEnvVar.add(builder); } else { _visitables.get("customEnvVar").set(index, builder); customEnvVar.set(index, builder);}
    return (A)this;
  }
  
  public A addToCustomEnvVar(io.dekorate.kubernetes.config.Env... items) {
    if (this.customEnvVar == null) {this.customEnvVar = new ArrayList<EnvBuilder>();}
    for (Env item : items) {EnvBuilder builder = new EnvBuilder(item);_visitables.get("customEnvVar").add(builder);this.customEnvVar.add(builder);} return (A)this;
  }
  
  public A addAllToCustomEnvVar(Collection<Env> items) {
    if (this.customEnvVar == null) {this.customEnvVar = new ArrayList<EnvBuilder>();}
    for (Env item : items) {EnvBuilder builder = new EnvBuilder(item);_visitables.get("customEnvVar").add(builder);this.customEnvVar.add(builder);} return (A)this;
  }
  
  public A removeFromCustomEnvVar(io.dekorate.kubernetes.config.Env... items) {
    if (this.customEnvVar == null) return (A)this;
    for (Env item : items) {EnvBuilder builder = new EnvBuilder(item);_visitables.get("customEnvVar").remove(builder); this.customEnvVar.remove(builder);} return (A)this;
  }
  
  public A removeAllFromCustomEnvVar(Collection<Env> items) {
    if (this.customEnvVar == null) return (A)this;
    for (Env item : items) {EnvBuilder builder = new EnvBuilder(item);_visitables.get("customEnvVar").remove(builder); this.customEnvVar.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromCustomEnvVar(Predicate<EnvBuilder> predicate) {
    if (customEnvVar == null) return (A) this;
    final Iterator<EnvBuilder> each = customEnvVar.iterator();
    final List visitables = _visitables.get("customEnvVar");
    while (each.hasNext()) {
      EnvBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public boolean hasCustomEnvVar() {
    return this.customEnvVar != null && !this.customEnvVar.isEmpty();
  }
  
  public CustomEnvVarNested<A> addNewCustomEnvVar() {
    return new CustomEnvVarNested(-1, null);
  }
  
  public CustomEnvVarNested<A> addNewCustomEnvVarLike(Env item) {
    return new CustomEnvVarNested(-1, item);
  }
  
  public CustomEnvVarNested<A> setNewCustomEnvVarLike(int index,Env item) {
    return new CustomEnvVarNested(index, item);
  }
  
  public CustomEnvVarNested<A> editCustomEnvVar(int index) {
    if (customEnvVar.size() <= index) throw new RuntimeException("Can't edit customEnvVar. Index exceeds size.");
    return setNewCustomEnvVarLike(index, buildCustomEnvVar(index));
  }
  
  public CustomEnvVarNested<A> editFirstCustomEnvVar() {
    if (customEnvVar.size() == 0) throw new RuntimeException("Can't edit first customEnvVar. The list is empty.");
    return setNewCustomEnvVarLike(0, buildCustomEnvVar(0));
  }
  
  public CustomEnvVarNested<A> editLastCustomEnvVar() {
    int index = customEnvVar.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last customEnvVar. The list is empty.");
    return setNewCustomEnvVarLike(index, buildCustomEnvVar(index));
  }
  
  public CustomEnvVarNested<A> editMatchingCustomEnvVar(Predicate<EnvBuilder> predicate) {
    int index = -1;
    for (int i=0;i<customEnvVar.size();i++) { 
    if (predicate.test(customEnvVar.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching customEnvVar. No match found.");
    return setNewCustomEnvVarLike(index, buildCustomEnvVar(index));
  }
  
  public BindingPathConfig buildBindingPath() {
    return this.bindingPath != null ? this.bindingPath.build() : null;
  }
  
  public A withBindingPath(BindingPathConfig bindingPath) {
    this._visitables.remove("bindingPath");
    if (bindingPath != null) {
        this.bindingPath = new BindingPathConfigBuilder(bindingPath);
        this._visitables.get("bindingPath").add(this.bindingPath);
    } else {
        this.bindingPath = null;
        this._visitables.get("bindingPath").remove(this.bindingPath);
    }
    return (A) this;
  }
  
  public boolean hasBindingPath() {
    return this.bindingPath != null;
  }
  
  public BindingPathNested<A> withNewBindingPath() {
    return new BindingPathNested(null);
  }
  
  public BindingPathNested<A> withNewBindingPathLike(BindingPathConfig item) {
    return new BindingPathNested(item);
  }
  
  public BindingPathNested<A> editBindingPath() {
    return withNewBindingPathLike(java.util.Optional.ofNullable(buildBindingPath()).orElse(null));
  }
  
  public BindingPathNested<A> editOrNewBindingPath() {
    return withNewBindingPathLike(java.util.Optional.ofNullable(buildBindingPath()).orElse(new BindingPathConfigBuilder().build()));
  }
  
  public BindingPathNested<A> editOrNewBindingPathLike(BindingPathConfig item) {
    return withNewBindingPathLike(java.util.Optional.ofNullable(buildBindingPath()).orElse(item));
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ServiceBindingConfigFluent that = (ServiceBindingConfigFluent) o;
    if (!java.util.Objects.equals(application, that.application)) return false;
    if (!java.util.Objects.equals(services, that.services)) return false;
    if (!java.util.Objects.equals(envVarPrefix, that.envVarPrefix)) return false;
    if (!java.util.Objects.equals(detectBindingResources, that.detectBindingResources)) return false;
    if (!java.util.Objects.equals(bindAsFiles, that.bindAsFiles)) return false;
    if (!java.util.Objects.equals(mountPath, that.mountPath)) return false;
    if (!java.util.Objects.equals(customEnvVar, that.customEnvVar)) return false;
    if (!java.util.Objects.equals(bindingPath, that.bindingPath)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(application,  services,  envVarPrefix,  detectBindingResources,  bindAsFiles,  mountPath,  customEnvVar,  bindingPath,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (application != null) { sb.append("application:"); sb.append(application + ","); }
    if (services != null && !services.isEmpty()) { sb.append("services:"); sb.append(services + ","); }
    if (envVarPrefix != null) { sb.append("envVarPrefix:"); sb.append(envVarPrefix + ","); }
    if (detectBindingResources != null) { sb.append("detectBindingResources:"); sb.append(detectBindingResources + ","); }
    if (bindAsFiles != null) { sb.append("bindAsFiles:"); sb.append(bindAsFiles + ","); }
    if (mountPath != null) { sb.append("mountPath:"); sb.append(mountPath + ","); }
    if (customEnvVar != null && !customEnvVar.isEmpty()) { sb.append("customEnvVar:"); sb.append(customEnvVar + ","); }
    if (bindingPath != null) { sb.append("bindingPath:"); sb.append(bindingPath); }
    sb.append("}");
    return sb.toString();
  }
  
  public A withDetectBindingResources() {
    return withDetectBindingResources(true);
  }
  
  public A withBindAsFiles() {
    return withBindAsFiles(true);
  }
  public class ApplicationNested<N> extends ApplicationConfigFluent<ApplicationNested<N>> implements Nested<N>{
    ApplicationNested(ApplicationConfig item) {
      this.builder = new ApplicationConfigBuilder(this, item);
    }
    ApplicationConfigBuilder builder;
    
    public N and() {
      return (N) ServiceBindingConfigFluent.this.withApplication(builder.build());
    }
    
    public N endApplication() {
      return and();
    }
    
  
  }
  public class ServicesNested<N> extends ServiceConfigFluent<ServicesNested<N>> implements Nested<N>{
    ServicesNested(int index,ServiceConfig item) {
      this.index = index;
      this.builder = new ServiceConfigBuilder(this, item);
    }
    ServiceConfigBuilder builder;
    int index;
    
    public N and() {
      return (N) ServiceBindingConfigFluent.this.setToServices(index,builder.build());
    }
    
    public N endService() {
      return and();
    }
    
  
  }
  public class CustomEnvVarNested<N> extends EnvFluent<CustomEnvVarNested<N>> implements Nested<N>{
    CustomEnvVarNested(int index,Env item) {
      this.index = index;
      this.builder = new EnvBuilder(this, item);
    }
    EnvBuilder builder;
    int index;
    
    public N and() {
      return (N) ServiceBindingConfigFluent.this.setToCustomEnvVar(index,builder.build());
    }
    
    public N endCustomEnvVar() {
      return and();
    }
    
  
  }
  public class BindingPathNested<N> extends BindingPathConfigFluent<BindingPathNested<N>> implements Nested<N>{
    BindingPathNested(BindingPathConfig item) {
      this.builder = new BindingPathConfigBuilder(this, item);
    }
    BindingPathConfigBuilder builder;
    
    public N and() {
      return (N) ServiceBindingConfigFluent.this.withBindingPath(builder.build());
    }
    
    public N endBindingPath() {
      return and();
    }
    
  
  }

}