package io.dekorate.servicebinding.config;

import io.dekorate.project.Project;
import io.dekorate.kubernetes.config.ConfigKey;
import io.dekorate.kubernetes.config.Configuration;
import java.lang.Object;
import java.lang.String;
import java.util.Map;
import io.sundr.builder.annotations.Buildable;

/**
 * Generated
 */
@Buildable(refs = {@io.sundr.builder.annotations.BuildableReference(io.dekorate.project.Project.class),@io.sundr.builder.annotations.BuildableReference(io.dekorate.project.BuildInfo.class)} ,builderPackage = "io.fabric8.kubernetes.api.builder")
public class ServiceConfig extends Configuration{
  public ServiceConfig() {
  }
  
  public ServiceConfig(Project project,Map<ConfigKey,Object> attributes,String group,String kind,String name,String version,String id,String namespace,String envVarPrefix) {
    super(project, attributes);
    this.group = group;
    this.kind = kind;
    this.name = name;
    this.version = version;
    this.id = id;
    this.namespace = namespace;
    this.envVarPrefix = envVarPrefix;
  }
  private String group;
  private String kind;
  private String name;
  private String version;
  private String id;
  private String namespace;
  private String envVarPrefix;
  
  public String getGroup() {
    return this.group;
  }
  
  public String getKind() {
    return this.kind;
  }
  
  public String getName() {
    return this.name;
  }
  
  public String getVersion() {
    return this.version;
  }
  
  public String getId() {
    return this.id;
  }
  
  public String getNamespace() {
    return this.namespace;
  }
  
  public String getEnvVarPrefix() {
    return this.envVarPrefix;
  }
  
  public static ServiceConfigBuilder newServiceConfigBuilder() {
    return new ServiceConfigBuilder();
  }
  
  public static ServiceConfigBuilder newServiceConfigBuilderFromDefaults() {
    return new ServiceConfigBuilder();
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ServiceConfig that = (ServiceConfig) o;
    if (!java.util.Objects.equals(group, that.group)) return false;
    if (!java.util.Objects.equals(kind, that.kind)) return false;
    if (!java.util.Objects.equals(name, that.name)) return false;
    if (!java.util.Objects.equals(version, that.version)) return false;
    if (!java.util.Objects.equals(id, that.id)) return false;
    if (!java.util.Objects.equals(namespace, that.namespace)) return false;
    if (!java.util.Objects.equals(envVarPrefix, that.envVarPrefix)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(group,  kind,  name,  version,  id,  namespace,  envVarPrefix,  super.hashCode());
  }
  

}