package io.dekorate.servicebinding.config;

import java.lang.SuppressWarnings;
import java.lang.Object;
import io.dekorate.kubernetes.config.ConfigurationFluent;
import java.lang.String;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class ServiceConfigFluent<A extends ServiceConfigFluent<A>> extends ConfigurationFluent<A>{
  public ServiceConfigFluent() {
  }
  
  public ServiceConfigFluent(ServiceConfig instance) {
    this.copyInstance(instance);
  }
  private String group;
  private String kind;
  private String name;
  private String version;
  private String id;
  private String namespace;
  private String envVarPrefix;
  
  protected void copyInstance(ServiceConfig instance) {
    instance = (instance != null ? instance : new ServiceConfig());
    if (instance != null) {
          this.withProject(instance.getProject());
          this.withAttributes(instance.getAttributes());
          this.withGroup(instance.getGroup());
          this.withKind(instance.getKind());
          this.withName(instance.getName());
          this.withVersion(instance.getVersion());
          this.withId(instance.getId());
          this.withNamespace(instance.getNamespace());
          this.withEnvVarPrefix(instance.getEnvVarPrefix());
        }
  }
  
  public String getGroup() {
    return this.group;
  }
  
  public A withGroup(String group) {
    this.group = group;
    return (A) this;
  }
  
  public boolean hasGroup() {
    return this.group != null;
  }
  
  public String getKind() {
    return this.kind;
  }
  
  public A withKind(String kind) {
    this.kind = kind;
    return (A) this;
  }
  
  public boolean hasKind() {
    return this.kind != null;
  }
  
  public String getName() {
    return this.name;
  }
  
  public A withName(String name) {
    this.name = name;
    return (A) this;
  }
  
  public boolean hasName() {
    return this.name != null;
  }
  
  public String getVersion() {
    return this.version;
  }
  
  public A withVersion(String version) {
    this.version = version;
    return (A) this;
  }
  
  public boolean hasVersion() {
    return this.version != null;
  }
  
  public String getId() {
    return this.id;
  }
  
  public A withId(String id) {
    this.id = id;
    return (A) this;
  }
  
  public boolean hasId() {
    return this.id != null;
  }
  
  public String getNamespace() {
    return this.namespace;
  }
  
  public A withNamespace(String namespace) {
    this.namespace = namespace;
    return (A) this;
  }
  
  public boolean hasNamespace() {
    return this.namespace != null;
  }
  
  public String getEnvVarPrefix() {
    return this.envVarPrefix;
  }
  
  public A withEnvVarPrefix(String envVarPrefix) {
    this.envVarPrefix = envVarPrefix;
    return (A) this;
  }
  
  public boolean hasEnvVarPrefix() {
    return this.envVarPrefix != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ServiceConfigFluent that = (ServiceConfigFluent) o;
    if (!java.util.Objects.equals(group, that.group)) return false;
    if (!java.util.Objects.equals(kind, that.kind)) return false;
    if (!java.util.Objects.equals(name, that.name)) return false;
    if (!java.util.Objects.equals(version, that.version)) return false;
    if (!java.util.Objects.equals(id, that.id)) return false;
    if (!java.util.Objects.equals(namespace, that.namespace)) return false;
    if (!java.util.Objects.equals(envVarPrefix, that.envVarPrefix)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(group,  kind,  name,  version,  id,  namespace,  envVarPrefix,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (group != null) { sb.append("group:"); sb.append(group + ","); }
    if (kind != null) { sb.append("kind:"); sb.append(kind + ","); }
    if (name != null) { sb.append("name:"); sb.append(name + ","); }
    if (version != null) { sb.append("version:"); sb.append(version + ","); }
    if (id != null) { sb.append("id:"); sb.append(id + ","); }
    if (namespace != null) { sb.append("namespace:"); sb.append(namespace + ","); }
    if (envVarPrefix != null) { sb.append("envVarPrefix:"); sb.append(envVarPrefix); }
    sb.append("}");
    return sb.toString();
  }
  

}