package io.dekorate.servicebinding.model;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.Object;
import java.lang.String;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class ApplicationFluent<A extends ApplicationFluent<A>> extends BaseFluent<A>{
  public ApplicationFluent() {
  }
  
  public ApplicationFluent(Application instance) {
    this.copyInstance(instance);
  }
  private String resource;
  private String kind;
  private String group;
  private String version;
  private String name;
  private BindingPathBuilder bindingPath;
  
  protected void copyInstance(Application instance) {
    instance = (instance != null ? instance : new Application());
    if (instance != null) {
          this.withResource(instance.getResource());
          this.withKind(instance.getKind());
          this.withGroup(instance.getGroup());
          this.withVersion(instance.getVersion());
          this.withName(instance.getName());
          this.withBindingPath(instance.getBindingPath());
        }
  }
  
  public String getResource() {
    return this.resource;
  }
  
  public A withResource(String resource) {
    this.resource = resource;
    return (A) this;
  }
  
  public boolean hasResource() {
    return this.resource != null;
  }
  
  public String getKind() {
    return this.kind;
  }
  
  public A withKind(String kind) {
    this.kind = kind;
    return (A) this;
  }
  
  public boolean hasKind() {
    return this.kind != null;
  }
  
  public String getGroup() {
    return this.group;
  }
  
  public A withGroup(String group) {
    this.group = group;
    return (A) this;
  }
  
  public boolean hasGroup() {
    return this.group != null;
  }
  
  public String getVersion() {
    return this.version;
  }
  
  public A withVersion(String version) {
    this.version = version;
    return (A) this;
  }
  
  public boolean hasVersion() {
    return this.version != null;
  }
  
  public String getName() {
    return this.name;
  }
  
  public A withName(String name) {
    this.name = name;
    return (A) this;
  }
  
  public boolean hasName() {
    return this.name != null;
  }
  
  public BindingPath buildBindingPath() {
    return this.bindingPath != null ? this.bindingPath.build() : null;
  }
  
  public A withBindingPath(BindingPath bindingPath) {
    this._visitables.remove("bindingPath");
    if (bindingPath != null) {
        this.bindingPath = new BindingPathBuilder(bindingPath);
        this._visitables.get("bindingPath").add(this.bindingPath);
    } else {
        this.bindingPath = null;
        this._visitables.get("bindingPath").remove(this.bindingPath);
    }
    return (A) this;
  }
  
  public boolean hasBindingPath() {
    return this.bindingPath != null;
  }
  
  public A withNewBindingPath(String containerPath,String secretPath) {
    return (A)withBindingPath(new BindingPath(containerPath, secretPath));
  }
  
  public BindingPathNested<A> withNewBindingPath() {
    return new BindingPathNested(null);
  }
  
  public BindingPathNested<A> withNewBindingPathLike(BindingPath item) {
    return new BindingPathNested(item);
  }
  
  public BindingPathNested<A> editBindingPath() {
    return withNewBindingPathLike(java.util.Optional.ofNullable(buildBindingPath()).orElse(null));
  }
  
  public BindingPathNested<A> editOrNewBindingPath() {
    return withNewBindingPathLike(java.util.Optional.ofNullable(buildBindingPath()).orElse(new BindingPathBuilder().build()));
  }
  
  public BindingPathNested<A> editOrNewBindingPathLike(BindingPath item) {
    return withNewBindingPathLike(java.util.Optional.ofNullable(buildBindingPath()).orElse(item));
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ApplicationFluent that = (ApplicationFluent) o;
    if (!java.util.Objects.equals(resource, that.resource)) return false;
    if (!java.util.Objects.equals(kind, that.kind)) return false;
    if (!java.util.Objects.equals(group, that.group)) return false;
    if (!java.util.Objects.equals(version, that.version)) return false;
    if (!java.util.Objects.equals(name, that.name)) return false;
    if (!java.util.Objects.equals(bindingPath, that.bindingPath)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(resource,  kind,  group,  version,  name,  bindingPath,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (resource != null) { sb.append("resource:"); sb.append(resource + ","); }
    if (kind != null) { sb.append("kind:"); sb.append(kind + ","); }
    if (group != null) { sb.append("group:"); sb.append(group + ","); }
    if (version != null) { sb.append("version:"); sb.append(version + ","); }
    if (name != null) { sb.append("name:"); sb.append(name + ","); }
    if (bindingPath != null) { sb.append("bindingPath:"); sb.append(bindingPath); }
    sb.append("}");
    return sb.toString();
  }
  public class BindingPathNested<N> extends BindingPathFluent<BindingPathNested<N>> implements Nested<N>{
    BindingPathNested(BindingPath item) {
      this.builder = new BindingPathBuilder(this, item);
    }
    BindingPathBuilder builder;
    
    public N and() {
      return (N) ApplicationFluent.this.withBindingPath(builder.build());
    }
    
    public N endBindingPath() {
      return and();
    }
    
  
  }

}