package io.dekorate.servicebinding.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class BindingPathBuilder extends BindingPathFluent<BindingPathBuilder> implements VisitableBuilder<BindingPath,BindingPathBuilder>{
  public BindingPathBuilder() {
    this.fluent = this;
  }
  
  public BindingPathBuilder(BindingPathFluent<?> fluent) {
    this.fluent = fluent;
  }
  
  public BindingPathBuilder(BindingPathFluent<?> fluent,BindingPath instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public BindingPathBuilder(BindingPath instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  BindingPathFluent<?> fluent;
  
  public BindingPath build() {
    BindingPath buildable = new BindingPath(fluent.getContainerPath(),fluent.getSecretPath());
    return buildable;
  }
  

}