package io.dekorate.servicebinding.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class ConfigMapKeyRefBuilder extends ConfigMapKeyRefFluent<ConfigMapKeyRefBuilder> implements VisitableBuilder<ConfigMapKeyRef,ConfigMapKeyRefBuilder>{
  public ConfigMapKeyRefBuilder() {
    this.fluent = this;
  }
  
  public ConfigMapKeyRefBuilder(ConfigMapKeyRefFluent<?> fluent) {
    this.fluent = fluent;
  }
  
  public ConfigMapKeyRefBuilder(ConfigMapKeyRefFluent<?> fluent,ConfigMapKeyRef instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public ConfigMapKeyRefBuilder(ConfigMapKeyRef instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  ConfigMapKeyRefFluent<?> fluent;
  
  public ConfigMapKeyRef build() {
    ConfigMapKeyRef buildable = new ConfigMapKeyRef(fluent.getKey(),fluent.getName(),fluent.isOptional());
    return buildable;
  }
  

}