package io.dekorate.servicebinding.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class ResourceFieldRefBuilder extends ResourceFieldRefFluent<ResourceFieldRefBuilder> implements VisitableBuilder<ResourceFieldRef,ResourceFieldRefBuilder>{
  public ResourceFieldRefBuilder() {
    this.fluent = this;
  }
  
  public ResourceFieldRefBuilder(ResourceFieldRefFluent<?> fluent) {
    this.fluent = fluent;
  }
  
  public ResourceFieldRefBuilder(ResourceFieldRefFluent<?> fluent,ResourceFieldRef instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public ResourceFieldRefBuilder(ResourceFieldRef instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  ResourceFieldRefFluent<?> fluent;
  
  public ResourceFieldRef build() {
    ResourceFieldRef buildable = new ResourceFieldRef(fluent.getContainerName(),fluent.getDivisor(),fluent.getResource());
    return buildable;
  }
  

}