package io.dekorate.servicebinding.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class SecretKeyRefBuilder extends SecretKeyRefFluent<SecretKeyRefBuilder> implements VisitableBuilder<SecretKeyRef,SecretKeyRefBuilder>{
  public SecretKeyRefBuilder() {
    this.fluent = this;
  }
  
  public SecretKeyRefBuilder(SecretKeyRefFluent<?> fluent) {
    this.fluent = fluent;
  }
  
  public SecretKeyRefBuilder(SecretKeyRefFluent<?> fluent,SecretKeyRef instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public SecretKeyRefBuilder(SecretKeyRef instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  SecretKeyRefFluent<?> fluent;
  
  public SecretKeyRef build() {
    SecretKeyRef buildable = new SecretKeyRef(fluent.getKey(),fluent.getName(),fluent.isOptional());
    return buildable;
  }
  

}