package io.dekorate.servicebinding.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class ServiceBindingBuilder extends ServiceBindingFluent<ServiceBindingBuilder> implements VisitableBuilder<ServiceBinding,ServiceBindingBuilder>{
  public ServiceBindingBuilder() {
    this(new ServiceBinding());
  }
  
  public ServiceBindingBuilder(ServiceBindingFluent<?> fluent) {
    this(fluent, new ServiceBinding());
  }
  
  public ServiceBindingBuilder(ServiceBindingFluent<?> fluent,ServiceBinding instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public ServiceBindingBuilder(ServiceBinding instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  ServiceBindingFluent<?> fluent;
  
  public ServiceBinding build() {
    ServiceBinding buildable = new ServiceBinding(fluent.getKind(),fluent.getApiVersion(),fluent.buildMetadata(),fluent.buildSpec(),fluent.buildStatus());
    return buildable;
  }
  

}