package io.dekorate.servicebinding.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.util.Collection;
import java.lang.Object;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class ServiceBindingSpecFluent<A extends ServiceBindingSpecFluent<A>> extends BaseFluent<A>{
  public ServiceBindingSpecFluent() {
  }
  
  public ServiceBindingSpecFluent(ServiceBindingSpec instance) {
    this.copyInstance(instance);
  }
  private ApplicationBuilder application;
  private ArrayList<ServiceBuilder> services;
  private String envVarPrefix;
  private boolean detectBindingResources;
  private boolean bindAsFiles;
  private String mountPath;
  private ArrayList<CustomEnvVarBuilder> customEnvVar;
  
  protected void copyInstance(ServiceBindingSpec instance) {
    instance = (instance != null ? instance : new ServiceBindingSpec());
    if (instance != null) {
          this.withApplication(instance.getApplication());
          this.withServices(instance.getServices());
          this.withEnvVarPrefix(instance.getEnvVarPrefix());
          this.withDetectBindingResources(instance.getDetectBindingResources());
          this.withBindAsFiles(instance.isBindAsFiles());
          this.withMountPath(instance.getMountPath());
          this.withCustomEnvVar(instance.getCustomEnvVar());
        }
  }
  
  public Application buildApplication() {
    return this.application != null ? this.application.build() : null;
  }
  
  public A withApplication(Application application) {
    this._visitables.remove("application");
    if (application != null) {
        this.application = new ApplicationBuilder(application);
        this._visitables.get("application").add(this.application);
    } else {
        this.application = null;
        this._visitables.get("application").remove(this.application);
    }
    return (A) this;
  }
  
  public boolean hasApplication() {
    return this.application != null;
  }
  
  public ApplicationNested<A> withNewApplication() {
    return new ApplicationNested(null);
  }
  
  public ApplicationNested<A> withNewApplicationLike(Application item) {
    return new ApplicationNested(item);
  }
  
  public ApplicationNested<A> editApplication() {
    return withNewApplicationLike(java.util.Optional.ofNullable(buildApplication()).orElse(null));
  }
  
  public ApplicationNested<A> editOrNewApplication() {
    return withNewApplicationLike(java.util.Optional.ofNullable(buildApplication()).orElse(new ApplicationBuilder().build()));
  }
  
  public ApplicationNested<A> editOrNewApplicationLike(Application item) {
    return withNewApplicationLike(java.util.Optional.ofNullable(buildApplication()).orElse(item));
  }
  
  public A withServices(io.dekorate.servicebinding.model.Service... services) {
    if (this.services != null) {
        this.services.clear();
        _visitables.remove("services");
    }
    if (services != null) {
      for (Service item : services) {
        this.addToServices(item);
      }
    }
    return (A) this;
  }
  
  public Service[] buildServices() {
    int size = services != null ? services.size() : 0;;
    Service[] result = new Service[size];;
    if (size == 0) {
      return result;
    }
    int index = 0;;
    for (VisitableBuilder<Service,ServiceBuilder> item : services) {
      result[index++] = item.build();
    }
    return result;
  }
  
  public Service buildService(int index) {
    return this.services.get(index).build();
  }
  
  public Service buildFirstService() {
    return this.services.get(0).build();
  }
  
  public Service buildLastService() {
    return this.services.get(services.size() - 1).build();
  }
  
  public Service buildMatchingService(Predicate<ServiceBuilder> predicate) {
      for (ServiceBuilder item : services) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingService(Predicate<ServiceBuilder> predicate) {
      for (ServiceBuilder item : services) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A addToServices(int index,Service item) {
    if (this.services == null) {this.services = new ArrayList<ServiceBuilder>();}
    ServiceBuilder builder = new ServiceBuilder(item);
    if (index < 0 || index >= services.size()) { _visitables.get("services").add(builder); services.add(builder); } else { _visitables.get("services").add(index, builder); services.add(index, builder);}
    return (A)this;
  }
  
  public A setToServices(int index,Service item) {
    if (this.services == null) {this.services = new ArrayList<ServiceBuilder>();}
    ServiceBuilder builder = new ServiceBuilder(item);
    if (index < 0 || index >= services.size()) { _visitables.get("services").add(builder); services.add(builder); } else { _visitables.get("services").set(index, builder); services.set(index, builder);}
    return (A)this;
  }
  
  public A addToServices(io.dekorate.servicebinding.model.Service... items) {
    if (this.services == null) {this.services = new ArrayList<ServiceBuilder>();}
    for (Service item : items) {ServiceBuilder builder = new ServiceBuilder(item);_visitables.get("services").add(builder);this.services.add(builder);} return (A)this;
  }
  
  public A addAllToServices(Collection<Service> items) {
    if (this.services == null) {this.services = new ArrayList<ServiceBuilder>();}
    for (Service item : items) {ServiceBuilder builder = new ServiceBuilder(item);_visitables.get("services").add(builder);this.services.add(builder);} return (A)this;
  }
  
  public A removeFromServices(io.dekorate.servicebinding.model.Service... items) {
    if (this.services == null) return (A)this;
    for (Service item : items) {ServiceBuilder builder = new ServiceBuilder(item);_visitables.get("services").remove(builder); this.services.remove(builder);} return (A)this;
  }
  
  public A removeAllFromServices(Collection<Service> items) {
    if (this.services == null) return (A)this;
    for (Service item : items) {ServiceBuilder builder = new ServiceBuilder(item);_visitables.get("services").remove(builder); this.services.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromServices(Predicate<ServiceBuilder> predicate) {
    if (services == null) return (A) this;
    final Iterator<ServiceBuilder> each = services.iterator();
    final List visitables = _visitables.get("services");
    while (each.hasNext()) {
      ServiceBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public boolean hasServices() {
    return this.services != null && !this.services.isEmpty();
  }
  
  public ServicesNested<A> addNewService() {
    return new ServicesNested(-1, null);
  }
  
  public ServicesNested<A> addNewServiceLike(Service item) {
    return new ServicesNested(-1, item);
  }
  
  public ServicesNested<A> setNewServiceLike(int index,Service item) {
    return new ServicesNested(index, item);
  }
  
  public ServicesNested<A> editService(int index) {
    if (services.size() <= index) throw new RuntimeException("Can't edit services. Index exceeds size.");
    return setNewServiceLike(index, buildService(index));
  }
  
  public ServicesNested<A> editFirstService() {
    if (services.size() == 0) throw new RuntimeException("Can't edit first services. The list is empty.");
    return setNewServiceLike(0, buildService(0));
  }
  
  public ServicesNested<A> editLastService() {
    int index = services.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last services. The list is empty.");
    return setNewServiceLike(index, buildService(index));
  }
  
  public ServicesNested<A> editMatchingService(Predicate<ServiceBuilder> predicate) {
    int index = -1;
    for (int i=0;i<services.size();i++) { 
    if (predicate.test(services.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching services. No match found.");
    return setNewServiceLike(index, buildService(index));
  }
  
  public String getEnvVarPrefix() {
    return this.envVarPrefix;
  }
  
  public A withEnvVarPrefix(String envVarPrefix) {
    this.envVarPrefix = envVarPrefix;
    return (A) this;
  }
  
  public boolean hasEnvVarPrefix() {
    return this.envVarPrefix != null;
  }
  
  public boolean isDetectBindingResources() {
    return this.detectBindingResources;
  }
  
  public A withDetectBindingResources(boolean detectBindingResources) {
    this.detectBindingResources = detectBindingResources;
    return (A) this;
  }
  
  public boolean hasDetectBindingResources() {
    return true;
  }
  
  public boolean isBindAsFiles() {
    return this.bindAsFiles;
  }
  
  public A withBindAsFiles(boolean bindAsFiles) {
    this.bindAsFiles = bindAsFiles;
    return (A) this;
  }
  
  public boolean hasBindAsFiles() {
    return true;
  }
  
  public String getMountPath() {
    return this.mountPath;
  }
  
  public A withMountPath(String mountPath) {
    this.mountPath = mountPath;
    return (A) this;
  }
  
  public boolean hasMountPath() {
    return this.mountPath != null;
  }
  
  public A withCustomEnvVar(io.dekorate.servicebinding.model.CustomEnvVar... customEnvVar) {
    if (this.customEnvVar != null) {
        this.customEnvVar.clear();
        _visitables.remove("customEnvVar");
    }
    if (customEnvVar != null) {
      for (CustomEnvVar item : customEnvVar) {
        this.addToCustomEnvVar(item);
      }
    }
    return (A) this;
  }
  
  public CustomEnvVar[] buildCustomEnvVar() {
    int size = customEnvVar != null ? customEnvVar.size() : 0;;
    CustomEnvVar[] result = new CustomEnvVar[size];;
    if (size == 0) {
      return result;
    }
    int index = 0;;
    for (VisitableBuilder<CustomEnvVar,CustomEnvVarBuilder> item : customEnvVar) {
      result[index++] = item.build();
    }
    return result;
  }
  
  public CustomEnvVar buildCustomEnvVar(int index) {
    return this.customEnvVar.get(index).build();
  }
  
  public CustomEnvVar buildFirstCustomEnvVar() {
    return this.customEnvVar.get(0).build();
  }
  
  public CustomEnvVar buildLastCustomEnvVar() {
    return this.customEnvVar.get(customEnvVar.size() - 1).build();
  }
  
  public CustomEnvVar buildMatchingCustomEnvVar(Predicate<CustomEnvVarBuilder> predicate) {
      for (CustomEnvVarBuilder item : customEnvVar) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingCustomEnvVar(Predicate<CustomEnvVarBuilder> predicate) {
      for (CustomEnvVarBuilder item : customEnvVar) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A addToCustomEnvVar(int index,CustomEnvVar item) {
    if (this.customEnvVar == null) {this.customEnvVar = new ArrayList<CustomEnvVarBuilder>();}
    CustomEnvVarBuilder builder = new CustomEnvVarBuilder(item);
    if (index < 0 || index >= customEnvVar.size()) { _visitables.get("customEnvVar").add(builder); customEnvVar.add(builder); } else { _visitables.get("customEnvVar").add(index, builder); customEnvVar.add(index, builder);}
    return (A)this;
  }
  
  public A setToCustomEnvVar(int index,CustomEnvVar item) {
    if (this.customEnvVar == null) {this.customEnvVar = new ArrayList<CustomEnvVarBuilder>();}
    CustomEnvVarBuilder builder = new CustomEnvVarBuilder(item);
    if (index < 0 || index >= customEnvVar.size()) { _visitables.get("customEnvVar").add(builder); customEnvVar.add(builder); } else { _visitables.get("customEnvVar").set(index, builder); customEnvVar.set(index, builder);}
    return (A)this;
  }
  
  public A addToCustomEnvVar(io.dekorate.servicebinding.model.CustomEnvVar... items) {
    if (this.customEnvVar == null) {this.customEnvVar = new ArrayList<CustomEnvVarBuilder>();}
    for (CustomEnvVar item : items) {CustomEnvVarBuilder builder = new CustomEnvVarBuilder(item);_visitables.get("customEnvVar").add(builder);this.customEnvVar.add(builder);} return (A)this;
  }
  
  public A addAllToCustomEnvVar(Collection<CustomEnvVar> items) {
    if (this.customEnvVar == null) {this.customEnvVar = new ArrayList<CustomEnvVarBuilder>();}
    for (CustomEnvVar item : items) {CustomEnvVarBuilder builder = new CustomEnvVarBuilder(item);_visitables.get("customEnvVar").add(builder);this.customEnvVar.add(builder);} return (A)this;
  }
  
  public A removeFromCustomEnvVar(io.dekorate.servicebinding.model.CustomEnvVar... items) {
    if (this.customEnvVar == null) return (A)this;
    for (CustomEnvVar item : items) {CustomEnvVarBuilder builder = new CustomEnvVarBuilder(item);_visitables.get("customEnvVar").remove(builder); this.customEnvVar.remove(builder);} return (A)this;
  }
  
  public A removeAllFromCustomEnvVar(Collection<CustomEnvVar> items) {
    if (this.customEnvVar == null) return (A)this;
    for (CustomEnvVar item : items) {CustomEnvVarBuilder builder = new CustomEnvVarBuilder(item);_visitables.get("customEnvVar").remove(builder); this.customEnvVar.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromCustomEnvVar(Predicate<CustomEnvVarBuilder> predicate) {
    if (customEnvVar == null) return (A) this;
    final Iterator<CustomEnvVarBuilder> each = customEnvVar.iterator();
    final List visitables = _visitables.get("customEnvVar");
    while (each.hasNext()) {
      CustomEnvVarBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public boolean hasCustomEnvVar() {
    return this.customEnvVar != null && !this.customEnvVar.isEmpty();
  }
  
  public CustomEnvVarNested<A> addNewCustomEnvVar() {
    return new CustomEnvVarNested(-1, null);
  }
  
  public CustomEnvVarNested<A> addNewCustomEnvVarLike(CustomEnvVar item) {
    return new CustomEnvVarNested(-1, item);
  }
  
  public CustomEnvVarNested<A> setNewCustomEnvVarLike(int index,CustomEnvVar item) {
    return new CustomEnvVarNested(index, item);
  }
  
  public CustomEnvVarNested<A> editCustomEnvVar(int index) {
    if (customEnvVar.size() <= index) throw new RuntimeException("Can't edit customEnvVar. Index exceeds size.");
    return setNewCustomEnvVarLike(index, buildCustomEnvVar(index));
  }
  
  public CustomEnvVarNested<A> editFirstCustomEnvVar() {
    if (customEnvVar.size() == 0) throw new RuntimeException("Can't edit first customEnvVar. The list is empty.");
    return setNewCustomEnvVarLike(0, buildCustomEnvVar(0));
  }
  
  public CustomEnvVarNested<A> editLastCustomEnvVar() {
    int index = customEnvVar.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last customEnvVar. The list is empty.");
    return setNewCustomEnvVarLike(index, buildCustomEnvVar(index));
  }
  
  public CustomEnvVarNested<A> editMatchingCustomEnvVar(Predicate<CustomEnvVarBuilder> predicate) {
    int index = -1;
    for (int i=0;i<customEnvVar.size();i++) { 
    if (predicate.test(customEnvVar.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching customEnvVar. No match found.");
    return setNewCustomEnvVarLike(index, buildCustomEnvVar(index));
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ServiceBindingSpecFluent that = (ServiceBindingSpecFluent) o;
    if (!java.util.Objects.equals(application, that.application)) return false;
    if (!java.util.Objects.equals(services, that.services)) return false;
    if (!java.util.Objects.equals(envVarPrefix, that.envVarPrefix)) return false;
    if (detectBindingResources != that.detectBindingResources) return false;
    if (bindAsFiles != that.bindAsFiles) return false;
    if (!java.util.Objects.equals(mountPath, that.mountPath)) return false;
    if (!java.util.Objects.equals(customEnvVar, that.customEnvVar)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(application,  services,  envVarPrefix,  detectBindingResources,  bindAsFiles,  mountPath,  customEnvVar,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (application != null) { sb.append("application:"); sb.append(application + ","); }
    if (services != null && !services.isEmpty()) { sb.append("services:"); sb.append(services + ","); }
    if (envVarPrefix != null) { sb.append("envVarPrefix:"); sb.append(envVarPrefix + ","); }
    sb.append("detectBindingResources:"); sb.append(detectBindingResources + ",");
    sb.append("bindAsFiles:"); sb.append(bindAsFiles + ",");
    if (mountPath != null) { sb.append("mountPath:"); sb.append(mountPath + ","); }
    if (customEnvVar != null && !customEnvVar.isEmpty()) { sb.append("customEnvVar:"); sb.append(customEnvVar); }
    sb.append("}");
    return sb.toString();
  }
  
  public A withDetectBindingResources() {
    return withDetectBindingResources(true);
  }
  
  public A withBindAsFiles() {
    return withBindAsFiles(true);
  }
  public class ApplicationNested<N> extends ApplicationFluent<ApplicationNested<N>> implements Nested<N>{
    ApplicationNested(Application item) {
      this.builder = new ApplicationBuilder(this, item);
    }
    ApplicationBuilder builder;
    
    public N and() {
      return (N) ServiceBindingSpecFluent.this.withApplication(builder.build());
    }
    
    public N endApplication() {
      return and();
    }
    
  
  }
  public class ServicesNested<N> extends ServiceFluent<ServicesNested<N>> implements Nested<N>{
    ServicesNested(int index,Service item) {
      this.index = index;
      this.builder = new ServiceBuilder(this, item);
    }
    ServiceBuilder builder;
    int index;
    
    public N and() {
      return (N) ServiceBindingSpecFluent.this.setToServices(index,builder.build());
    }
    
    public N endService() {
      return and();
    }
    
  
  }
  public class CustomEnvVarNested<N> extends CustomEnvVarFluent<CustomEnvVarNested<N>> implements Nested<N>{
    CustomEnvVarNested(int index,CustomEnvVar item) {
      this.index = index;
      this.builder = new CustomEnvVarBuilder(this, item);
    }
    CustomEnvVarBuilder builder;
    int index;
    
    public N and() {
      return (N) ServiceBindingSpecFluent.this.setToCustomEnvVar(index,builder.build());
    }
    
    public N endCustomEnvVar() {
      return and();
    }
    
  
  }

}