package io.dekorate.servicebinding.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class ServiceBindingStatusFluent<A extends ServiceBindingStatusFluent<A>> extends BaseFluent<A>{
  public ServiceBindingStatusFluent() {
  }
  
  public ServiceBindingStatusFluent(ServiceBindingStatus instance) {
    this.copyInstance(instance);
  }
  private ArrayList<ServiceBindingConditionBuilder> conditions;
  
  protected void copyInstance(ServiceBindingStatus instance) {
    instance = (instance != null ? instance : new ServiceBindingStatus());
    if (instance != null) {
          this.withConditions(instance.getConditions());
        }
  }
  
  public A addToConditions(int index,ServiceBindingCondition item) {
    if (this.conditions == null) {this.conditions = new ArrayList<ServiceBindingConditionBuilder>();}
    ServiceBindingConditionBuilder builder = new ServiceBindingConditionBuilder(item);
    if (index < 0 || index >= conditions.size()) { _visitables.get("conditions").add(builder); conditions.add(builder); } else { _visitables.get("conditions").add(index, builder); conditions.add(index, builder);}
    return (A)this;
  }
  
  public A setToConditions(int index,ServiceBindingCondition item) {
    if (this.conditions == null) {this.conditions = new ArrayList<ServiceBindingConditionBuilder>();}
    ServiceBindingConditionBuilder builder = new ServiceBindingConditionBuilder(item);
    if (index < 0 || index >= conditions.size()) { _visitables.get("conditions").add(builder); conditions.add(builder); } else { _visitables.get("conditions").set(index, builder); conditions.set(index, builder);}
    return (A)this;
  }
  
  public A addToConditions(io.dekorate.servicebinding.model.ServiceBindingCondition... items) {
    if (this.conditions == null) {this.conditions = new ArrayList<ServiceBindingConditionBuilder>();}
    for (ServiceBindingCondition item : items) {ServiceBindingConditionBuilder builder = new ServiceBindingConditionBuilder(item);_visitables.get("conditions").add(builder);this.conditions.add(builder);} return (A)this;
  }
  
  public A addAllToConditions(Collection<ServiceBindingCondition> items) {
    if (this.conditions == null) {this.conditions = new ArrayList<ServiceBindingConditionBuilder>();}
    for (ServiceBindingCondition item : items) {ServiceBindingConditionBuilder builder = new ServiceBindingConditionBuilder(item);_visitables.get("conditions").add(builder);this.conditions.add(builder);} return (A)this;
  }
  
  public A removeFromConditions(io.dekorate.servicebinding.model.ServiceBindingCondition... items) {
    if (this.conditions == null) return (A)this;
    for (ServiceBindingCondition item : items) {ServiceBindingConditionBuilder builder = new ServiceBindingConditionBuilder(item);_visitables.get("conditions").remove(builder); this.conditions.remove(builder);} return (A)this;
  }
  
  public A removeAllFromConditions(Collection<ServiceBindingCondition> items) {
    if (this.conditions == null) return (A)this;
    for (ServiceBindingCondition item : items) {ServiceBindingConditionBuilder builder = new ServiceBindingConditionBuilder(item);_visitables.get("conditions").remove(builder); this.conditions.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromConditions(Predicate<ServiceBindingConditionBuilder> predicate) {
    if (conditions == null) return (A) this;
    final Iterator<ServiceBindingConditionBuilder> each = conditions.iterator();
    final List visitables = _visitables.get("conditions");
    while (each.hasNext()) {
      ServiceBindingConditionBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<ServiceBindingCondition> buildConditions() {
    return this.conditions != null ? build(conditions) : null;
  }
  
  public ServiceBindingCondition buildCondition(int index) {
    return this.conditions.get(index).build();
  }
  
  public ServiceBindingCondition buildFirstCondition() {
    return this.conditions.get(0).build();
  }
  
  public ServiceBindingCondition buildLastCondition() {
    return this.conditions.get(conditions.size() - 1).build();
  }
  
  public ServiceBindingCondition buildMatchingCondition(Predicate<ServiceBindingConditionBuilder> predicate) {
      for (ServiceBindingConditionBuilder item : conditions) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingCondition(Predicate<ServiceBindingConditionBuilder> predicate) {
      for (ServiceBindingConditionBuilder item : conditions) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withConditions(List<ServiceBindingCondition> conditions) {
    if (this.conditions != null) {
      this._visitables.get("conditions").clear();
    }
    if (conditions != null) {
        this.conditions = new ArrayList();
        for (ServiceBindingCondition item : conditions) {
          this.addToConditions(item);
        }
    } else {
      this.conditions = null;
    }
    return (A) this;
  }
  
  public A withConditions(io.dekorate.servicebinding.model.ServiceBindingCondition... conditions) {
    if (this.conditions != null) {
        this.conditions.clear();
        _visitables.remove("conditions");
    }
    if (conditions != null) {
      for (ServiceBindingCondition item : conditions) {
        this.addToConditions(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasConditions() {
    return this.conditions != null && !this.conditions.isEmpty();
  }
  
  public ConditionsNested<A> addNewCondition() {
    return new ConditionsNested(-1, null);
  }
  
  public ConditionsNested<A> addNewConditionLike(ServiceBindingCondition item) {
    return new ConditionsNested(-1, item);
  }
  
  public ConditionsNested<A> setNewConditionLike(int index,ServiceBindingCondition item) {
    return new ConditionsNested(index, item);
  }
  
  public ConditionsNested<A> editCondition(int index) {
    if (conditions.size() <= index) throw new RuntimeException("Can't edit conditions. Index exceeds size.");
    return setNewConditionLike(index, buildCondition(index));
  }
  
  public ConditionsNested<A> editFirstCondition() {
    if (conditions.size() == 0) throw new RuntimeException("Can't edit first conditions. The list is empty.");
    return setNewConditionLike(0, buildCondition(0));
  }
  
  public ConditionsNested<A> editLastCondition() {
    int index = conditions.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last conditions. The list is empty.");
    return setNewConditionLike(index, buildCondition(index));
  }
  
  public ConditionsNested<A> editMatchingCondition(Predicate<ServiceBindingConditionBuilder> predicate) {
    int index = -1;
    for (int i=0;i<conditions.size();i++) { 
    if (predicate.test(conditions.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching conditions. No match found.");
    return setNewConditionLike(index, buildCondition(index));
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ServiceBindingStatusFluent that = (ServiceBindingStatusFluent) o;
    if (!java.util.Objects.equals(conditions, that.conditions)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(conditions,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (conditions != null && !conditions.isEmpty()) { sb.append("conditions:"); sb.append(conditions); }
    sb.append("}");
    return sb.toString();
  }
  public class ConditionsNested<N> extends ServiceBindingConditionFluent<ConditionsNested<N>> implements Nested<N>{
    ConditionsNested(int index,ServiceBindingCondition item) {
      this.index = index;
      this.builder = new ServiceBindingConditionBuilder(this, item);
    }
    ServiceBindingConditionBuilder builder;
    int index;
    
    public N and() {
      return (N) ServiceBindingStatusFluent.this.setToConditions(index,builder.build());
    }
    
    public N endCondition() {
      return and();
    }
    
  
  }

}