/*
 * Decompiled with CFR 0.152.
 */
package io.delta.flink.sink;

import io.delta.flink.internal.options.DeltaConnectorConfiguration;
import io.delta.flink.internal.options.OptionValidator;
import io.delta.flink.sink.DeltaSink;
import io.delta.flink.sink.internal.DeltaBucketAssigner;
import io.delta.flink.sink.internal.DeltaPartitionComputer;
import io.delta.flink.sink.internal.DeltaSinkBuilder;
import io.delta.flink.sink.internal.DeltaSinkOptions;
import org.apache.flink.core.fs.Path;
import org.apache.flink.formats.parquet.ParquetWriterFactory;
import org.apache.flink.formats.parquet.row.ParquetRowDataBuilder;
import org.apache.flink.streaming.api.functions.sink.filesystem.BucketAssigner;
import org.apache.flink.streaming.api.functions.sink.filesystem.bucketassigners.BasePathBucketAssigner;
import org.apache.flink.streaming.api.functions.sink.filesystem.rollingpolicies.CheckpointRollingPolicy;
import org.apache.flink.streaming.api.functions.sink.filesystem.rollingpolicies.OnCheckpointRollingPolicy;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.types.logical.RowType;
import org.apache.hadoop.conf.Configuration;

public class RowDataDeltaSinkBuilder {
    private final Path tableBasePath;
    private final RowType rowType;
    private final Configuration conf;
    private boolean mergeSchema;
    private String[] partitionColumns = new String[0];
    private final DeltaConnectorConfiguration sinkConfiguration = new DeltaConnectorConfiguration();
    private final OptionValidator optionValidator;

    public RowDataDeltaSinkBuilder(Path path, Configuration configuration, RowType rowType, boolean bl) {
        this.tableBasePath = path;
        this.conf = configuration;
        this.rowType = rowType;
        this.mergeSchema = bl;
        this.optionValidator = new OptionValidator(path, this.sinkConfiguration, DeltaSinkOptions.USER_FACING_SINK_OPTIONS);
    }

    public RowDataDeltaSinkBuilder withMergeSchema(boolean bl) {
        this.mergeSchema = bl;
        return this;
    }

    public RowDataDeltaSinkBuilder withPartitionColumns(String ... stringArray) {
        this.partitionColumns = stringArray;
        return this;
    }

    public RowDataDeltaSinkBuilder option(String string, String string2) {
        this.optionValidator.option(string, string2);
        return this;
    }

    public RowDataDeltaSinkBuilder option(String string, boolean bl) {
        this.optionValidator.option(string, bl);
        return this;
    }

    public RowDataDeltaSinkBuilder option(String string, int n) {
        this.optionValidator.option(string, n);
        return this;
    }

    public RowDataDeltaSinkBuilder option(String string, long l) {
        this.optionValidator.option(string, l);
        return this;
    }

    public DeltaSink<RowData> build() {
        this.conf.set("parquet.compression", "SNAPPY");
        ParquetWriterFactory parquetWriterFactory = ParquetRowDataBuilder.createWriterFactory((RowType)this.rowType, (Configuration)this.conf, (boolean)true);
        DeltaSinkBuilder.DefaultDeltaFormatBuilder<RowData> defaultDeltaFormatBuilder = new DeltaSinkBuilder.DefaultDeltaFormatBuilder<RowData>(this.tableBasePath, this.conf, (ParquetWriterFactory<RowData>)parquetWriterFactory, this.resolveBucketAssigner(), (CheckpointRollingPolicy<RowData, String>)OnCheckpointRollingPolicy.build(), this.rowType, this.mergeSchema, this.sinkConfiguration);
        return new DeltaSink<RowData>(defaultDeltaFormatBuilder);
    }

    private BucketAssigner<RowData, String> resolveBucketAssigner() {
        if (this.partitionColumns == null || this.partitionColumns.length == 0) {
            return new BasePathBucketAssigner();
        }
        DeltaPartitionComputer.DeltaRowDataPartitionComputer deltaRowDataPartitionComputer = new DeltaPartitionComputer.DeltaRowDataPartitionComputer(this.rowType, this.partitionColumns);
        return new DeltaBucketAssigner<RowData>(deltaRowDataPartitionComputer);
    }
}

