/*
 * Decompiled with CFR 0.152.
 */
package io.delta.flink.source.internal;

import io.delta.flink.internal.options.BooleanOptionTypeConverter;
import io.delta.flink.internal.options.DeltaConfigOption;
import io.delta.flink.internal.options.NonNegativeNumberTypeConverter;
import io.delta.flink.internal.options.StartingVersionOptionTypeConverter;
import io.delta.flink.internal.options.TimestampOptionTypeConverter;
import java.util.HashMap;
import java.util.Map;
import org.apache.flink.configuration.ConfigOptions;

public class DeltaSourceOptions {
    public static final String STARTING_VERSION_LATEST = "latest";
    public static final Map<String, DeltaConfigOption<?>> USER_FACING_SOURCE_OPTIONS = new HashMap();
    public static final Map<String, DeltaConfigOption<?>> INNER_SOURCE_OPTIONS = new HashMap();
    public static final DeltaConfigOption<Long> VERSION_AS_OF = DeltaConfigOption.of(ConfigOptions.key((String)"versionAsOf").longType().noDefaultValue(), Long.class, new NonNegativeNumberTypeConverter());
    public static final DeltaConfigOption<Long> TIMESTAMP_AS_OF = DeltaConfigOption.of(ConfigOptions.key((String)"timestampAsOf").longType().noDefaultValue(), Long.class, new TimestampOptionTypeConverter());
    public static final DeltaConfigOption<String> STARTING_VERSION = DeltaConfigOption.of(ConfigOptions.key((String)"startingVersion").stringType().noDefaultValue(), String.class, new StartingVersionOptionTypeConverter());
    public static final DeltaConfigOption<Long> STARTING_TIMESTAMP = DeltaConfigOption.of(ConfigOptions.key((String)"startingTimestamp").longType().noDefaultValue(), Long.class, new TimestampOptionTypeConverter());
    public static final DeltaConfigOption<Long> UPDATE_CHECK_INTERVAL = DeltaConfigOption.of(ConfigOptions.key((String)"updateCheckIntervalMillis").longType().defaultValue((Object)5000L), Long.class, new NonNegativeNumberTypeConverter());
    public static final DeltaConfigOption<Long> UPDATE_CHECK_INITIAL_DELAY = DeltaConfigOption.of(ConfigOptions.key((String)"updateCheckDelayMillis").longType().defaultValue((Object)1000L), Long.class, new NonNegativeNumberTypeConverter());
    public static final DeltaConfigOption<Boolean> IGNORE_DELETES = DeltaConfigOption.of(ConfigOptions.key((String)"ignoreDeletes").booleanType().defaultValue((Object)false), Boolean.class, new BooleanOptionTypeConverter());
    public static final DeltaConfigOption<Boolean> IGNORE_CHANGES = DeltaConfigOption.of(ConfigOptions.key((String)"ignoreChanges").booleanType().defaultValue((Object)false), Boolean.class, new BooleanOptionTypeConverter());
    public static final DeltaConfigOption<Integer> PARQUET_BATCH_SIZE = DeltaConfigOption.of(ConfigOptions.key((String)"parquetBatchSize").intType().defaultValue((Object)2048), Integer.class, new NonNegativeNumberTypeConverter());
    public static final DeltaConfigOption<Long> LOADED_SCHEMA_SNAPSHOT_VERSION = DeltaConfigOption.of(ConfigOptions.key((String)"loadedSchemaSnapshotVersion").longType().noDefaultValue(), Long.class);

    public static boolean isUserFacingOption(String string) {
        return USER_FACING_SOURCE_OPTIONS.containsKey(string);
    }

    static {
        USER_FACING_SOURCE_OPTIONS.put(VERSION_AS_OF.key(), VERSION_AS_OF);
        USER_FACING_SOURCE_OPTIONS.put(TIMESTAMP_AS_OF.key(), TIMESTAMP_AS_OF);
        USER_FACING_SOURCE_OPTIONS.put(STARTING_VERSION.key(), STARTING_VERSION);
        USER_FACING_SOURCE_OPTIONS.put(STARTING_TIMESTAMP.key(), STARTING_TIMESTAMP);
        USER_FACING_SOURCE_OPTIONS.put(UPDATE_CHECK_INTERVAL.key(), UPDATE_CHECK_INTERVAL);
        USER_FACING_SOURCE_OPTIONS.put(UPDATE_CHECK_INITIAL_DELAY.key(), UPDATE_CHECK_INITIAL_DELAY);
        USER_FACING_SOURCE_OPTIONS.put(IGNORE_DELETES.key(), IGNORE_DELETES);
        USER_FACING_SOURCE_OPTIONS.put(IGNORE_CHANGES.key(), IGNORE_CHANGES);
        USER_FACING_SOURCE_OPTIONS.put(PARQUET_BATCH_SIZE.key(), PARQUET_BATCH_SIZE);
        INNER_SOURCE_OPTIONS.put(LOADED_SCHEMA_SNAPSHOT_VERSION.key(), LOADED_SCHEMA_SNAPSHOT_VERSION);
    }
}

