/*
 * Decompiled with CFR 0.152.
 */
package io.delta.flink.internal.options;

import io.delta.flink.internal.options.DefaultOptionTypeConverter;
import io.delta.flink.internal.options.DeltaConnectorConfiguration;
import io.delta.flink.internal.options.OptionTypeConverter;
import org.apache.flink.configuration.ConfigOption;

public class DeltaConfigOption<T> {
    private final ConfigOption<T> decoratedOption;
    private final Class<T> decoratedType;
    private final OptionTypeConverter<T> typeConverter;

    private DeltaConfigOption(ConfigOption<T> configOption, Class<T> clazz, OptionTypeConverter<T> optionTypeConverter) {
        this.decoratedOption = configOption;
        this.decoratedType = clazz;
        this.typeConverter = optionTypeConverter;
    }

    public static <T> DeltaConfigOption<T> of(ConfigOption<T> configOption, Class<T> clazz) {
        return new DeltaConfigOption<Object>(configOption, clazz, new DefaultOptionTypeConverter());
    }

    public static <T> DeltaConfigOption<T> of(ConfigOption<T> configOption, Class<T> clazz, OptionTypeConverter<T> optionTypeConverter) {
        return new DeltaConfigOption<T>(configOption, clazz, optionTypeConverter);
    }

    public Class<T> getValueType() {
        return this.decoratedType;
    }

    public String key() {
        return this.decoratedOption.key();
    }

    public T defaultValue() {
        return (T)this.decoratedOption.defaultValue();
    }

    public void setOnConfig(DeltaConnectorConfiguration deltaConnectorConfiguration, boolean bl) {
        Object t = this.typeConverter.convertType(this, bl);
        deltaConnectorConfiguration.addOption(this, t);
    }

    public void setOnConfig(DeltaConnectorConfiguration deltaConnectorConfiguration, int n) {
        Object t = this.typeConverter.convertType(this, n);
        deltaConnectorConfiguration.addOption(this, t);
    }

    public void setOnConfig(DeltaConnectorConfiguration deltaConnectorConfiguration, long l) {
        Object t = this.typeConverter.convertType(this, l);
        deltaConnectorConfiguration.addOption(this, t);
    }

    public void setOnConfig(DeltaConnectorConfiguration deltaConnectorConfiguration, String string) {
        Object t = this.typeConverter.convertType(this, string);
        deltaConnectorConfiguration.addOption(this, t);
    }
}

