/*
 * Decompiled with CFR 0.152.
 */
package io.delta.flink.internal.options;

import io.delta.flink.internal.options.DeltaConfigOption;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public class DeltaConnectorConfiguration
implements Serializable {
    private final Map<String, Object> usedSourceOptions = new HashMap<String, Object>();

    public DeltaConnectorConfiguration() {
    }

    public DeltaConnectorConfiguration copy() {
        return new DeltaConnectorConfiguration(this.usedSourceOptions);
    }

    public DeltaConnectorConfiguration(Map<String, Object> map) {
        this.usedSourceOptions.putAll(map);
    }

    public <T> DeltaConnectorConfiguration addOption(DeltaConfigOption<T> deltaConfigOption, T t) {
        this.usedSourceOptions.put(deltaConfigOption.key(), t);
        return this;
    }

    public boolean hasOption(DeltaConfigOption<?> deltaConfigOption) {
        return this.usedSourceOptions.containsKey(deltaConfigOption.key());
    }

    public Set<String> getUsedOptions() {
        return this.usedSourceOptions.keySet();
    }

    public <T> T getValue(DeltaConfigOption<T> deltaConfigOption) {
        return this.getValue(deltaConfigOption.key()).orElse(deltaConfigOption.defaultValue());
    }

    private <T> Optional<T> getValue(String string) {
        return Optional.ofNullable(this.usedSourceOptions.get(string));
    }

    public String toString() {
        return "DeltaSourceConfiguration{usedSourceOptions=" + this.usedSourceOptions + '}';
    }
}

