/*
 * Decompiled with CFR 0.152.
 */
package io.delta.flink.internal.options;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public enum OptionType {
    STRING(String.class),
    BOOLEAN(Boolean.class),
    INTEGER(Integer.class),
    LONG(Long.class),
    OTHER(null);

    private static final Map<Class<?>, OptionType> LOOKUP_MAP;
    private final Class<?> optionType;

    private OptionType(Class<?> clazz) {
        this.optionType = clazz;
    }

    public static OptionType instanceFrom(Class<?> clazz) {
        return LOOKUP_MAP.getOrDefault(clazz, OTHER);
    }

    static {
        HashMap hashMap = new HashMap();
        for (OptionType optionType : OptionType.values()) {
            hashMap.put(optionType.optionType, optionType);
        }
        LOOKUP_MAP = Collections.unmodifiableMap(hashMap);
    }
}

