/*
 * Decompiled with CFR 0.152.
 */
package io.delta.flink.internal.table;

import io.delta.flink.internal.table.DeltaDynamicTableFactory;
import java.util.List;
import java.util.Optional;
import org.apache.flink.table.catalog.AbstractCatalog;
import org.apache.flink.table.catalog.Catalog;
import org.apache.flink.table.catalog.CatalogDatabase;
import org.apache.flink.table.catalog.CatalogFunction;
import org.apache.flink.table.catalog.ObjectPath;
import org.apache.flink.table.catalog.exceptions.CatalogException;
import org.apache.flink.table.catalog.exceptions.DatabaseAlreadyExistException;
import org.apache.flink.table.catalog.exceptions.DatabaseNotEmptyException;
import org.apache.flink.table.catalog.exceptions.DatabaseNotExistException;
import org.apache.flink.table.catalog.exceptions.FunctionAlreadyExistException;
import org.apache.flink.table.catalog.exceptions.FunctionNotExistException;
import org.apache.flink.table.catalog.exceptions.TableAlreadyExistException;
import org.apache.flink.table.catalog.exceptions.TableNotExistException;
import org.apache.flink.table.factories.Factory;

public abstract class BaseCatalog
extends AbstractCatalog {
    protected final Catalog decoratedCatalog;

    public BaseCatalog(String string, String string2, Catalog catalog) {
        super(string, string2);
        this.decoratedCatalog = catalog;
    }

    public Optional<Factory> getFactory() {
        return Optional.of(DeltaDynamicTableFactory.fromCatalog());
    }

    public void open() throws CatalogException {
        this.decoratedCatalog.open();
    }

    public void close() throws CatalogException {
        this.decoratedCatalog.close();
    }

    public List<String> listDatabases() throws CatalogException {
        return this.decoratedCatalog.listDatabases();
    }

    public CatalogDatabase getDatabase(String string) throws DatabaseNotExistException, CatalogException {
        return this.decoratedCatalog.getDatabase(string);
    }

    public boolean databaseExists(String string) throws CatalogException {
        return this.decoratedCatalog.databaseExists(string);
    }

    public void createDatabase(String string, CatalogDatabase catalogDatabase, boolean bl) throws DatabaseAlreadyExistException, CatalogException {
        this.decoratedCatalog.createDatabase(string, catalogDatabase, bl);
    }

    public void dropDatabase(String string, boolean bl, boolean bl2) throws DatabaseNotExistException, DatabaseNotEmptyException, CatalogException {
        this.decoratedCatalog.dropDatabase(string, bl, bl2);
    }

    public void alterDatabase(String string, CatalogDatabase catalogDatabase, boolean bl) throws DatabaseNotExistException, CatalogException {
        this.decoratedCatalog.alterDatabase(string, catalogDatabase, bl);
    }

    public List<String> listTables(String string) throws DatabaseNotExistException, CatalogException {
        return this.decoratedCatalog.listTables(string);
    }

    public void renameTable(ObjectPath objectPath, String string, boolean bl) throws TableNotExistException, TableAlreadyExistException, CatalogException {
        this.decoratedCatalog.renameTable(objectPath, string, bl);
    }

    public List<String> listViews(String string) throws DatabaseNotExistException, CatalogException {
        return this.decoratedCatalog.listViews(string);
    }

    public List<String> listFunctions(String string) throws DatabaseNotExistException, CatalogException {
        return this.decoratedCatalog.listFunctions(string);
    }

    public CatalogFunction getFunction(ObjectPath objectPath) throws FunctionNotExistException, CatalogException {
        return this.decoratedCatalog.getFunction(objectPath);
    }

    public boolean functionExists(ObjectPath objectPath) throws CatalogException {
        return this.decoratedCatalog.functionExists(objectPath);
    }

    public void createFunction(ObjectPath objectPath, CatalogFunction catalogFunction, boolean bl) throws FunctionAlreadyExistException, DatabaseNotExistException, CatalogException {
        this.decoratedCatalog.createFunction(objectPath, catalogFunction, bl);
    }

    public void alterFunction(ObjectPath objectPath, CatalogFunction catalogFunction, boolean bl) throws FunctionNotExistException, CatalogException {
        this.decoratedCatalog.alterFunction(objectPath, catalogFunction, bl);
    }

    public void dropFunction(ObjectPath objectPath, boolean bl) throws FunctionNotExistException, CatalogException {
        this.decoratedCatalog.dropFunction(objectPath, bl);
    }
}

