/*
 * Decompiled with CFR 0.152.
 */
package io.delta.flink.internal.table;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.delta.flink.internal.ConnectorUtils;
import io.delta.flink.internal.table.CatalogExceptionHelper;
import io.delta.flink.internal.table.DeltaFlinkJobSpecificOptions;
import io.delta.flink.internal.table.DeltaTableConnectorOptions;
import io.delta.flink.source.internal.SchemaConverter;
import io.delta.standalone.DeltaLog;
import io.delta.standalone.Operation;
import io.delta.standalone.OptimisticTransaction;
import io.delta.standalone.actions.Metadata;
import io.delta.standalone.types.StructField;
import io.delta.standalone.types.StructType;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.flink.table.api.Schema;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.catalog.CatalogBaseTable;
import org.apache.flink.table.catalog.CatalogTable;
import org.apache.flink.table.catalog.Column;
import org.apache.flink.table.catalog.ObjectPath;
import org.apache.flink.table.catalog.ResolvedCatalogTable;
import org.apache.flink.table.catalog.exceptions.CatalogException;
import org.apache.flink.table.factories.FactoryUtil;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.table.types.utils.LogicalTypeDataTypeConverter;
import org.apache.flink.util.Preconditions;

public final class DeltaCatalogTableHelper {
    private DeltaCatalogTableHelper() {
    }

    public static Pair<String[], DataType[]> resolveFlinkTypesFromDelta(StructType structType) {
        StructField[] structFieldArray = structType.getFields();
        String[] stringArray = new String[structFieldArray.length];
        DataType[] dataTypeArray = new DataType[structFieldArray.length];
        int n = 0;
        for (StructField structField : structFieldArray) {
            stringArray[n] = structField.getName();
            dataTypeArray[n] = LogicalTypeDataTypeConverter.toDataType((LogicalType)SchemaConverter.toFlinkDataType(structField.getDataType(), structField.isNullable()));
            ++n;
        }
        return Pair.of((Object)stringArray, (Object)dataTypeArray);
    }

    public static StructType resolveDeltaSchemaFromDdl(ResolvedCatalogTable resolvedCatalogTable) {
        List list = resolvedCatalogTable.getResolvedSchema().getColumns();
        DeltaCatalogTableHelper.validateNoDuplicateColumns(list);
        LinkedList<String> linkedList = new LinkedList<String>();
        LinkedList<LogicalType> linkedList2 = new LinkedList<LogicalType>();
        LinkedList<Column> linkedList3 = new LinkedList<Column>();
        for (Column column : list) {
            if (column instanceof Column.PhysicalColumn) {
                linkedList.add(column.getName());
                linkedList2.add(column.getDataType().getLogicalType());
            }
            if (!(column instanceof Column.ComputedColumn) && !(column instanceof Column.MetadataColumn)) continue;
            linkedList3.add(column);
        }
        if (linkedList3.isEmpty()) {
            return io.delta.flink.sink.internal.SchemaConverter.toDeltaDataType(RowType.of((LogicalType[])linkedList2.toArray(new LogicalType[0]), (String[])linkedList.toArray(new String[0])));
        }
        throw CatalogExceptionHelper.unsupportedColumnType(linkedList3);
    }

    public static void validateNoDuplicateColumns(List<Column> list) {
        List list2 = list.stream().map(Column::getName).collect(Collectors.toList());
        List list3 = list2.stream().filter(string -> Collections.frequency(list2, string) > 1).distinct().collect(Collectors.toList());
        if (list3.size() > 0) {
            throw new CatalogException(String.format("Schema must not contain duplicate column names. Found duplicates: %s", list3));
        }
    }

    public static void validateDdlSchemaAndPartitionSpecMatchesDelta(String string, ObjectPath objectPath, List<String> list, StructType structType, Metadata metadata) {
        StructType structType2 = metadata.getSchema();
        boolean bl = ConnectorUtils.listEqualsIgnoreOrder(list, metadata.getPartitionColumns());
        if (!structType.equals((Object)structType2) || !bl) {
            throw CatalogExceptionHelper.deltaLogAndDdlSchemaMismatchException(objectPath, string, metadata, structType, list);
        }
    }

    public static void commitToDeltaLog(DeltaLog deltaLog, Metadata metadata, Operation.Name name) {
        OptimisticTransaction optimisticTransaction = deltaLog.startTransaction();
        optimisticTransaction.updateMetadata(metadata);
        Operation operation = DeltaCatalogTableHelper.prepareDeltaLogOperation(name, metadata);
        optimisticTransaction.commit(Collections.singletonList(metadata), operation, "flink-engine/1.16.1 flink-delta-connector/3.2.1");
    }

    public static Operation prepareDeltaLogOperation(Operation.Name name, Metadata metadata) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            switch (name) {
                case CREATE_TABLE: {
                    hashMap.put("isManaged", objectMapper.writeValueAsString((Object)false));
                    hashMap.put("description", objectMapper.writeValueAsString((Object)metadata.getDescription()));
                    hashMap.put("properties", objectMapper.writeValueAsString((Object)objectMapper.writeValueAsString((Object)metadata.getConfiguration())));
                    hashMap.put("partitionBy", objectMapper.writeValueAsString((Object)objectMapper.writeValueAsString((Object)metadata.getPartitionColumns())));
                    break;
                }
                case SET_TABLE_PROPERTIES: {
                    hashMap.put("properties", objectMapper.writeValueAsString((Object)objectMapper.writeValueAsString((Object)metadata.getConfiguration())));
                    break;
                }
                default: {
                    throw new CatalogException(String.format("Trying to use unsupported Delta Operation [%s]", name.name()));
                }
            }
        }
        catch (JsonProcessingException jsonProcessingException) {
            throw new CatalogException("Cannot map object to JSON", (Throwable)jsonProcessingException);
        }
        return new Operation(name, hashMap, Collections.emptyMap());
    }

    public static Map<String, String> filterMetastoreDdlOptions(Map<String, String> map) {
        return map.entrySet().stream().filter(entry -> !((String)entry.getKey()).contains(FactoryUtil.CONNECTOR.key()) && !((String)entry.getKey()).contains(DeltaTableConnectorOptions.TABLE_PATH.key())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    public static DeltaMetastoreTable prepareMetastoreTable(CatalogBaseTable catalogBaseTable, String string) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put(FactoryUtil.CONNECTOR.key(), "delta");
        hashMap.put(DeltaTableConnectorOptions.TABLE_PATH.key(), string);
        return new DeltaMetastoreTable(CatalogTable.of((Schema)Schema.newBuilder().build(), (String)catalogBaseTable.getComment(), Collections.emptyList(), hashMap));
    }

    public static Map<String, String> prepareDeltaTableProperties(Map<String, String> map, ObjectPath objectPath, Metadata metadata, boolean bl) {
        Preconditions.checkArgument((!map.containsKey(DeltaTableConnectorOptions.TABLE_PATH.key()) ? 1 : 0) != 0, (Object)String.format("Filtered DDL options should not contain %s option.", DeltaTableConnectorOptions.TABLE_PATH.key()));
        Preconditions.checkArgument((!map.containsKey(FactoryUtil.CONNECTOR.key()) ? 1 : 0) != 0, (Object)String.format("Filtered DDL options should not contain %s option.", FactoryUtil.CONNECTOR.key()));
        LinkedList<CatalogExceptionHelper.MismatchedDdlOptionAndDeltaTableProperty> linkedList = new LinkedList<CatalogExceptionHelper.MismatchedDdlOptionAndDeltaTableProperty>();
        HashMap<String, String> hashMap = new HashMap<String, String>(metadata.getConfiguration());
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String string = hashMap.put(entry.getKey(), entry.getValue());
            if (bl || string == null || string.equals(entry.getValue())) continue;
            linkedList.add(new CatalogExceptionHelper.MismatchedDdlOptionAndDeltaTableProperty(entry.getKey(), entry.getValue(), string));
        }
        if (!linkedList.isEmpty()) {
            throw CatalogExceptionHelper.mismatchedDdlOptionAndDeltaTablePropertyException(objectPath, linkedList);
        }
        return hashMap;
    }

    public static void validateDdlOptions(Map<String, String> map) {
        CatalogExceptionHelper.InvalidDdlOptions invalidDdlOptions = new CatalogExceptionHelper.InvalidDdlOptions();
        for (String string : map.keySet()) {
            if (DeltaFlinkJobSpecificOptions.SOURCE_JOB_OPTIONS.contains(string)) {
                invalidDdlOptions.addJobSpecificOption(string);
            }
            if (!string.startsWith("spark.") && !string.startsWith("delta.logStore") && !string.startsWith("io.delta") && !string.startsWith("parquet.")) continue;
            invalidDdlOptions.addInvalidTableProperty(string);
        }
        if (invalidDdlOptions.hasInvalidOptions()) {
            throw CatalogExceptionHelper.invalidDdlOptionException(invalidDdlOptions);
        }
    }

    public static class DeltaMetastoreTable
    implements CatalogTable {
        private final CatalogTable decoratedTable;

        private DeltaMetastoreTable(CatalogTable catalogTable) {
            this.decoratedTable = catalogTable;
        }

        public boolean isPartitioned() {
            return this.decoratedTable.isPartitioned();
        }

        public List<String> getPartitionKeys() {
            return Collections.emptyList();
        }

        public CatalogTable copy(Map<String, String> map) {
            return this.decoratedTable.copy(map);
        }

        public Map<String, String> getOptions() {
            return this.decoratedTable.getOptions();
        }

        public TableSchema getSchema() {
            return TableSchema.builder().build();
        }

        public Schema getUnresolvedSchema() {
            return Schema.newBuilder().build();
        }

        public String getComment() {
            return this.decoratedTable.getComment();
        }

        public CatalogBaseTable copy() {
            return this.decoratedTable.copy();
        }

        public Optional<String> getDescription() {
            return this.decoratedTable.getDescription();
        }

        public Optional<String> getDetailedDescription() {
            return this.decoratedTable.getDetailedDescription();
        }
    }
}

