/*
 * Decompiled with CFR 0.152.
 */
package io.delta.flink.internal.table;

import java.io.File;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HadoopUtils {
    private static final Logger LOG = LoggerFactory.getLogger(HadoopUtils.class);
    private static final String[] FLINK_CONFIG_PREFIXES = new String[]{"flink.hadoop."};

    public static Configuration getHadoopConfiguration(org.apache.flink.configuration.Configuration configuration) {
        String string;
        String string2;
        String string32;
        Configuration configuration2 = new Configuration();
        boolean bl = false;
        String[] stringArray = new String[2];
        String string4 = System.getenv("HADOOP_HOME");
        if (string4 != null) {
            LOG.debug("Searching Hadoop configuration files in HADOOP_HOME: {}", (Object)string4);
            stringArray[0] = string4 + "/conf";
            stringArray[1] = string4 + "/etc/hadoop";
        }
        for (String string32 : stringArray) {
            if (string32 == null) continue;
            bl = HadoopUtils.addHadoopConfIfFound(configuration2, string32);
        }
        String string5 = configuration.getString("fs.hdfs.hdfsdefault", null);
        if (string5 != null) {
            configuration2.addResource(new Path(string5));
            LOG.debug("Using hdfs-default configuration-file path from Flink config: {}", (Object)string5);
            bl = true;
        }
        if ((string2 = configuration.getString("fs.hdfs.hdfssite", null)) != null) {
            configuration2.addResource(new Path(string2));
            LOG.debug("Using hdfs-site configuration-file path from Flink config: {}", (Object)string2);
            bl = true;
        }
        if ((string = configuration.getString("fs.hdfs.hadoopconf", null)) != null) {
            LOG.debug("Searching Hadoop configuration files in Flink config: {}", (Object)string);
            boolean bl2 = bl = HadoopUtils.addHadoopConfIfFound(configuration2, string) || bl;
        }
        if ((string32 = System.getenv("HADOOP_CONF_DIR")) != null) {
            LOG.debug("Searching Hadoop configuration files in HADOOP_CONF_DIR: {}", (Object)string32);
            bl = HadoopUtils.addHadoopConfIfFound(configuration2, string32) || bl;
        }
        for (String string6 : configuration.keySet()) {
            for (String string7 : FLINK_CONFIG_PREFIXES) {
                if (!string6.startsWith(string7)) continue;
                String string8 = string6.substring(string7.length());
                String string9 = configuration.getString(string6, null);
                configuration2.set(string8, string9);
                LOG.debug("Adding Flink config entry for {} as {}={} to Hadoop config", new Object[]{string6, string8, string9});
                bl = true;
            }
        }
        if (!bl) {
            LOG.warn("Could not find Hadoop configuration via any of the supported methods (Flink configuration, environment variables).");
        }
        return configuration2;
    }

    private static boolean addHadoopConfIfFound(Configuration configuration, String string) {
        boolean bl = false;
        if (new File(string).exists()) {
            if (new File(string + "/core-site.xml").exists()) {
                configuration.addResource(new Path(string + "/core-site.xml"));
                LOG.debug("Adding " + string + "/core-site.xml to hadoop configuration");
                bl = true;
            }
            if (new File(string + "/hdfs-site.xml").exists()) {
                configuration.addResource(new Path(string + "/hdfs-site.xml"));
                LOG.debug("Adding " + string + "/hdfs-site.xml to hadoop configuration");
                bl = true;
            }
        }
        return bl;
    }
}

