/*
 * Decompiled with CFR 0.152.
 */
package io.delta.flink.sink.internal.committer;

import io.delta.flink.sink.internal.committables.DeltaCommittable;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.apache.flink.api.connector.sink.Committer;
import org.apache.flink.streaming.api.functions.sink.filesystem.BucketWriter;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeltaCommitter
implements Committer<DeltaCommittable> {
    private static final Logger LOG = LoggerFactory.getLogger(DeltaCommitter.class);
    private final BucketWriter<?, ?> bucketWriter;

    public DeltaCommitter(BucketWriter<?, ?> bucketWriter) {
        this.bucketWriter = (BucketWriter)Preconditions.checkNotNull(bucketWriter);
    }

    public List<DeltaCommittable> commit(List<DeltaCommittable> list) throws IOException {
        for (DeltaCommittable deltaCommittable : list) {
            LOG.info("Committing delta committable locally: appId=" + deltaCommittable.getAppId() + " checkpointId=" + deltaCommittable.getCheckpointId() + " deltaPendingFile=" + deltaCommittable.getDeltaPendingFile());
            this.bucketWriter.recoverPendingFile(deltaCommittable.getDeltaPendingFile().getPendingFile()).commitAfterRecovery();
        }
        return Collections.emptyList();
    }

    public void close() {
    }
}

