/*
 * Decompiled with CFR 0.152.
 */
package io.delta.flink.source.internal.enumerator.supplier;

import io.delta.flink.internal.options.DeltaConnectorConfiguration;
import io.delta.flink.source.internal.DeltaSourceOptions;
import io.delta.flink.source.internal.enumerator.supplier.SnapshotSupplier;
import io.delta.flink.source.internal.utils.TransitiveOptional;
import io.delta.standalone.DeltaLog;
import io.delta.standalone.Snapshot;

public class BoundedSourceSnapshotSupplier
extends SnapshotSupplier {
    public BoundedSourceSnapshotSupplier(DeltaLog deltaLog) {
        super(deltaLog);
    }

    @Override
    public Snapshot getSnapshot(DeltaConnectorConfiguration deltaConnectorConfiguration) {
        return this.getSnapshotFromVersionAsOfOption(deltaConnectorConfiguration).or(() -> this.getSnapshotFromTimestampAsOfOption(deltaConnectorConfiguration)).or(this::getHeadSnapshot).get();
    }

    private TransitiveOptional<Snapshot> getSnapshotFromVersionAsOfOption(DeltaConnectorConfiguration deltaConnectorConfiguration) {
        Long l = deltaConnectorConfiguration.getValue(DeltaSourceOptions.VERSION_AS_OF);
        if (l != null) {
            return TransitiveOptional.ofNullable(this.deltaLog.getSnapshotForVersionAsOf(l.longValue()));
        }
        return TransitiveOptional.empty();
    }

    private TransitiveOptional<Snapshot> getSnapshotFromTimestampAsOfOption(DeltaConnectorConfiguration deltaConnectorConfiguration) {
        Long l = deltaConnectorConfiguration.getValue(DeltaSourceOptions.TIMESTAMP_AS_OF);
        if (l != null) {
            return TransitiveOptional.ofNullable(this.deltaLog.getSnapshotForTimestampAsOf(l.longValue()));
        }
        return TransitiveOptional.empty();
    }
}

