/*
 * Decompiled with CFR 0.152.
 */
package io.delta.flink.source.internal.enumerator.supplier;

import io.delta.flink.internal.options.DeltaConnectorConfiguration;
import io.delta.flink.source.internal.DeltaSourceOptions;
import io.delta.flink.source.internal.enumerator.supplier.SnapshotSupplier;
import io.delta.flink.source.internal.utils.TransitiveOptional;
import io.delta.standalone.DeltaLog;
import io.delta.standalone.Snapshot;

public class ContinuousSourceSnapshotSupplier
extends SnapshotSupplier {
    public ContinuousSourceSnapshotSupplier(DeltaLog deltaLog) {
        super(deltaLog);
    }

    @Override
    public Snapshot getSnapshot(DeltaConnectorConfiguration deltaConnectorConfiguration) {
        return this.getSnapshotFromStartingVersionOption(deltaConnectorConfiguration).or(() -> this.getSnapshotFromStartingTimestampOption(deltaConnectorConfiguration)).or(this::getHeadSnapshot).get();
    }

    private TransitiveOptional<Snapshot> getSnapshotFromStartingVersionOption(DeltaConnectorConfiguration deltaConnectorConfiguration) {
        String string = deltaConnectorConfiguration.getValue(DeltaSourceOptions.STARTING_VERSION);
        if (string != null) {
            if ("latest".equalsIgnoreCase(string)) {
                return TransitiveOptional.ofNullable(this.deltaLog.snapshot());
            }
            return TransitiveOptional.ofNullable(this.deltaLog.getSnapshotForVersionAsOf(Long.parseLong(string)));
        }
        return TransitiveOptional.empty();
    }

    private TransitiveOptional<Snapshot> getSnapshotFromStartingTimestampOption(DeltaConnectorConfiguration deltaConnectorConfiguration) {
        Long l = deltaConnectorConfiguration.getValue(DeltaSourceOptions.STARTING_TIMESTAMP);
        if (l != null) {
            long l2 = this.deltaLog.getVersionAtOrAfterTimestamp(l.longValue());
            return TransitiveOptional.ofNullable(this.deltaLog.getSnapshotForVersionAsOf(l2));
        }
        return TransitiveOptional.empty();
    }
}

