/*
 * Decompiled with CFR 0.152.
 */
package io.delta.flink.source.internal.file;

import io.delta.flink.source.internal.exceptions.DeltaSourceExceptions;
import io.delta.flink.source.internal.file.AddFileEnumerator;
import io.delta.flink.source.internal.file.AddFileEnumeratorContext;
import io.delta.flink.source.internal.state.DeltaSourceSplit;
import io.delta.standalone.actions.AddFile;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.core.fs.BlockLocation;
import org.apache.flink.core.fs.FileStatus;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.core.fs.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeltaFileEnumerator
implements AddFileEnumerator<DeltaSourceSplit> {
    public static final String SEPARATOR = "/";
    private static final Logger LOG = LoggerFactory.getLogger(DeltaFileEnumerator.class);
    private final char[] currentId = "0000000000".toCharArray();

    @Override
    public List<DeltaSourceSplit> enumerateSplits(AddFileEnumeratorContext addFileEnumeratorContext, AddFileEnumerator.SplitFilter<Path> splitFilter) {
        ArrayList<DeltaSourceSplit> arrayList = new ArrayList<DeltaSourceSplit>(addFileEnumeratorContext.getAddFiles().size());
        for (AddFile addFile : addFileEnumeratorContext.getAddFiles()) {
            Path path = this.acquireFilePath(addFileEnumeratorContext.getTablePath(), addFile);
            if (!splitFilter.test(path)) continue;
            this.tryConvertToSourceSplits(addFileEnumeratorContext, arrayList, addFile, path);
        }
        return arrayList;
    }

    private void tryConvertToSourceSplits(AddFileEnumeratorContext addFileEnumeratorContext, ArrayList<DeltaSourceSplit> arrayList, AddFile addFile, Path path) {
        try {
            FileSystem fileSystem = path.getFileSystem();
            FileStatus fileStatus = fileSystem.getFileStatus(path);
            this.convertToSourceSplits(fileStatus, fileSystem, addFile.getPartitionValues(), arrayList);
        }
        catch (IOException iOException) {
            throw DeltaSourceExceptions.fileEnumerationException(addFileEnumeratorContext, path, iOException);
        }
    }

    @VisibleForTesting
    Path acquireFilePath(String string, AddFile addFile) {
        String string2 = addFile.getPath();
        URI uRI = URI.create(string2);
        if (!uRI.isAbsolute()) {
            uRI = URI.create(this.getTablePath(string) + string2);
        }
        return new Path(uRI);
    }

    private String getTablePath(String string) {
        return string.endsWith(SEPARATOR) ? string : string + SEPARATOR;
    }

    private void convertToSourceSplits(FileStatus fileStatus, FileSystem fileSystem, Map<String, String> map, List<DeltaSourceSplit> list) throws IOException {
        BlockLocation[] blockLocationArray = this.getBlockLocationsForFile(fileStatus, fileSystem);
        if (blockLocationArray == null) {
            list.add(new DeltaSourceSplit(map, this.getNextId(), fileStatus.getPath(), 0L, fileStatus.getLen()));
        } else {
            for (BlockLocation blockLocation : blockLocationArray) {
                list.add(new DeltaSourceSplit(map, this.getNextId(), fileStatus.getPath(), blockLocation.getOffset(), blockLocation.getLength(), blockLocation.getHosts()));
            }
        }
    }

    @VisibleForTesting
    String getNextId() {
        this.incrementCharArrayByOne(this.currentId, this.currentId.length - 1);
        return new String(this.currentId);
    }

    private void incrementCharArrayByOne(char[] cArray, int n) {
        int n2 = cArray[n];
        if ((n2 = (char)(n2 + '\u0001')) > 57) {
            n2 = 48;
            this.incrementCharArrayByOne(cArray, n - 1);
        }
        cArray[n] = n2;
    }

    private BlockLocation[] getBlockLocationsForFile(FileStatus fileStatus, FileSystem fileSystem) throws IOException {
        long l = fileStatus.getLen();
        Object[] objectArray = fileSystem.getFileBlockLocations(fileStatus, 0L, l);
        if (objectArray == null || objectArray.length == 0) {
            return null;
        }
        long l2 = 0L;
        for (BlockLocation blockLocation : objectArray) {
            l2 += blockLocation.getLength();
        }
        if (l2 != l) {
            LOG.warn("Block lengths do not match file length for {}. File length is {}, blocks are {}", new Object[]{fileStatus.getPath(), l, Arrays.toString(objectArray)});
            return null;
        }
        return objectArray;
    }
}

