/*
 * Decompiled with CFR 0.152.
 */
package io.delta.standalone.internal;

import io.delta.kernel.data.ColumnVector;
import io.delta.kernel.internal.SnapshotImpl;
import io.delta.kernel.types.StructField;
import io.delta.standalone.DeltaScan;
import io.delta.standalone.Snapshot;
import io.delta.standalone.actions.AddFile;
import io.delta.standalone.actions.Format;
import io.delta.standalone.actions.Metadata;
import io.delta.standalone.data.CloseableIterator;
import io.delta.standalone.data.RowRecord;
import io.delta.standalone.expressions.Expression;
import io.delta.standalone.types.DataType;
import io.delta.standalone.types.FieldMetadata;
import io.delta.standalone.types.StructType;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KernelSnapshotWrapper
implements Snapshot {
    private static final Logger LOG = LoggerFactory.getLogger(KernelSnapshotWrapper.class);
    private Optional<Metadata> metadata = Optional.empty();
    private SnapshotImpl kernelSnapshot;

    public KernelSnapshotWrapper(SnapshotImpl snapshotImpl) {
        this.kernelSnapshot = snapshotImpl;
    }

    public Metadata getMetadata() {
        if (!this.metadata.isPresent()) {
            this.metadata = Optional.of(this.convertMetadata());
        }
        return this.metadata.get();
    }

    public long getVersion() {
        return this.kernelSnapshot.getVersion(null);
    }

    public DeltaScan scan() {
        throw new UnsupportedOperationException("not supported");
    }

    public DeltaScan scan(Expression expression) {
        throw new UnsupportedOperationException("not supported");
    }

    public List<AddFile> getAllFiles() {
        throw new UnsupportedOperationException("not supported");
    }

    public CloseableIterator<RowRecord> open() {
        throw new UnsupportedOperationException("not supported");
    }

    protected SnapshotImpl getKernelSnapshot() {
        return this.kernelSnapshot;
    }

    private Metadata convertMetadata() {
        io.delta.kernel.internal.actions.Metadata metadata = this.kernelSnapshot.getMetadata();
        io.delta.kernel.internal.actions.Format format = metadata.getFormat();
        Format format2 = new Format(format.getProvider(), Collections.emptyMap());
        ColumnVector columnVector = metadata.getPartitionColumns().getElements();
        ArrayList<String> arrayList = new ArrayList<String>(columnVector.getSize());
        for (int i = 0; i < columnVector.getSize(); ++i) {
            arrayList.add(columnVector.getString(i));
        }
        List list = metadata.getSchema().fields();
        io.delta.standalone.types.StructField[] structFieldArray = new io.delta.standalone.types.StructField[list.size()];
        int n = 0;
        for (StructField structField : list) {
            FieldMetadata fieldMetadata = FieldMetadata.builder().build();
            try {
                Constructor constructor = FieldMetadata.class.getDeclaredConstructor(Map.class);
                constructor.setAccessible(true);
                fieldMetadata = (FieldMetadata)constructor.newInstance(structField.getMetadata().getEntries());
            }
            catch (Exception exception) {
                LOG.warn("Failed to convert field metadata via private constructor. Using empty metadata", (Throwable)exception);
            }
            structFieldArray[n] = new io.delta.standalone.types.StructField(structField.getName(), DataType.fromJson((String)structField.getDataType().toJson()), structField.isNullable(), fieldMetadata);
            ++n;
        }
        StructType structType = new StructType(structFieldArray);
        return new Metadata(metadata.getId(), (String)metadata.getName().orElse(null), (String)metadata.getDescription().orElse(null), format2, arrayList, metadata.getConfiguration(), metadata.getCreatedTime(), structType);
    }
}

