/*
 * Decompiled with CFR 0.152.
 */
package io.delta.flink.internal.options;

import io.delta.flink.internal.options.BaseOptionTypeConverter;
import io.delta.flink.internal.options.DeltaConfigOption;
import io.delta.flink.internal.options.OptionType;
import java.util.regex.Pattern;
import org.apache.flink.util.StringUtils;

public class StartingVersionOptionTypeConverter
extends BaseOptionTypeConverter<String> {
    private final Pattern NON_NEGATIVE_INT_PATTERN = Pattern.compile("\\d+");

    @Override
    public <T> T convertType(DeltaConfigOption<T> deltaConfigOption, String string) {
        Class<T> clazz = deltaConfigOption.getValueType();
        OptionType optionType = OptionType.instanceFrom(clazz);
        if (optionType == OptionType.STRING) {
            if (StringUtils.isNullOrWhitespaceOnly((String)string)) {
                throw this.invalidValueException(deltaConfigOption.key(), string);
            }
            if ("latest".equalsIgnoreCase(string)) {
                return (T)string;
            }
            if (this.NON_NEGATIVE_INT_PATTERN.matcher(string).matches()) {
                return (T)string;
            }
            throw this.invalidValueException(deltaConfigOption.key(), string);
        }
        throw new IllegalArgumentException(String.format("StartingVersionOptionTypeConverter used with a incompatible DeltaConfigOption option type. This converter must be used only for DeltaConfigOption::String however it was used for '%s' with option '%s'", deltaConfigOption.getValueType(), deltaConfigOption.key()));
    }

    private IllegalArgumentException invalidValueException(String string, String string2) {
        return new IllegalArgumentException(String.format("Illegal value used for [%s] option. Expected values are non-negative integers or \"latest\" keyword (case insensitive). Used value was [%s]", string, string2));
    }
}

