/*
 * Decompiled with CFR 0.152.
 */
package io.delta.flink.internal.options;

import io.delta.flink.internal.options.BaseOptionTypeConverter;
import io.delta.flink.internal.options.DeltaConfigOption;
import io.delta.flink.internal.options.OptionType;
import io.delta.flink.source.internal.enumerator.supplier.TimestampFormatConverter;
import org.apache.flink.util.StringUtils;

public class TimestampOptionTypeConverter
extends BaseOptionTypeConverter<Long> {
    @Override
    public <T> T convertType(DeltaConfigOption<T> deltaConfigOption, String string) {
        Class<T> clazz = deltaConfigOption.getValueType();
        OptionType optionType = OptionType.instanceFrom(clazz);
        if (optionType == OptionType.LONG) {
            if (StringUtils.isNullOrWhitespaceOnly((String)string)) {
                throw this.invalidValueException(deltaConfigOption.key(), string);
            }
            return (T)Long.valueOf(TimestampFormatConverter.convertToTimestamp(string));
        }
        throw new IllegalArgumentException(String.format("TimestampOptionTypeConverter used with a incompatible DeltaConfigOption option type. This converter must be used only for DeltaConfigOption::Long however it was used for '%s' with option '%s'", deltaConfigOption.getValueType(), deltaConfigOption.key()));
    }

    private IllegalArgumentException invalidValueException(String string, String string2) {
        return new IllegalArgumentException(String.format("Illegal value used for [%s] option. Expected values are date/datetime String formats. Please see documentation for allowed formats. Used value was [%s]", string, string2));
    }
}

