/*
 * Decompiled with CFR 0.152.
 */
package io.delta.flink.internal.table;

import io.delta.flink.internal.table.DeltaFlinkJobSpecificOptions;
import io.delta.standalone.actions.Metadata;
import io.delta.standalone.types.StructType;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.catalog.Column;
import org.apache.flink.table.catalog.ObjectPath;
import org.apache.flink.table.catalog.exceptions.CatalogException;

public final class CatalogExceptionHelper {
    private static final String INVALID_PROPERTY_TEMPLATE = " - '%s'";
    private static final String ALLOWED_SELECT_JOB_SPECIFIC_OPTIONS = DeltaFlinkJobSpecificOptions.SOURCE_JOB_OPTIONS.stream().map(string -> String.format(INVALID_PROPERTY_TEMPLATE, string)).collect(Collectors.joining("\n"));

    private CatalogExceptionHelper() {
    }

    static CatalogException deltaLogAndDdlSchemaMismatchException(ObjectPath objectPath, String string, Metadata metadata, StructType structType, List<String> list) {
        String string2 = metadata.getSchema() == null ? "null" : metadata.getSchema().getTreeString();
        return new CatalogException(String.format(" Delta table [%s] from filesystem path [%s] has different schema or partition spec than one defined in CREATE TABLE DDL.\nDDL schema:\n[%s],\nDelta table schema:\n[%s]\nDDL partition spec:\n[%s],\nDelta Log partition spec\n[%s]\n", objectPath, string, structType.getTreeString(), string2, list, metadata.getPartitionColumns()));
    }

    public static CatalogException mismatchedDdlOptionAndDeltaTablePropertyException(ObjectPath objectPath, List<MismatchedDdlOptionAndDeltaTableProperty> list) {
        StringJoiner stringJoiner = new StringJoiner("\n");
        for (MismatchedDdlOptionAndDeltaTableProperty mismatchedDdlOptionAndDeltaTableProperty : list) {
            stringJoiner.add(String.join((CharSequence)" | ", mismatchedDdlOptionAndDeltaTableProperty.optionName, mismatchedDdlOptionAndDeltaTableProperty.ddlOptionValue, mismatchedDdlOptionAndDeltaTableProperty.deltaLogPropertyValue));
        }
        return new CatalogException(String.format("Invalid DDL options for table [%s]. DDL options for Delta table connector cannot override table properties already defined in _delta_log.\nDDL option name | DDL option value | Delta option value \n%s", objectPath.getFullName(), stringJoiner));
    }

    public static CatalogException unsupportedColumnType(Collection<Column> collection) {
        StringJoiner stringJoiner = new StringJoiner("\n");
        for (Column column : collection) {
            stringJoiner.add(String.join((CharSequence)" -> ", column.getName(), column.getClass().getSimpleName()));
        }
        return new CatalogException(String.format("Table definition contains unsupported column types. Currently, only physical columns are supported by Delta Flink connector.\nInvalid columns and types:\n%s", stringJoiner));
    }

    public static CatalogException invalidDdlOptionException(InvalidDdlOptions invalidDdlOptions) {
        String string2 = invalidDdlOptions.getInvalidTableProperties().stream().map(string -> String.format(INVALID_PROPERTY_TEMPLATE, string)).collect(Collectors.joining("\n"));
        String string3 = invalidDdlOptions.getJobSpecificOptions().stream().map(string -> String.format(INVALID_PROPERTY_TEMPLATE, string)).collect(Collectors.joining("\n"));
        String string4 = "DDL contains invalid properties. DDL can have only delta table properties or arbitrary user options only.";
        if (string2.length() > 0) {
            string4 = String.join((CharSequence)"\n", string4, String.format("Invalid options used:\n%s", string2));
        }
        if (string3.length() > 0) {
            string4 = String.join((CharSequence)"\n", string4, String.format("DDL contains job-specific options. Job-specific options can be used only via Query hints.\nUsed job-specific options:\n%s", string3));
        }
        return new CatalogException(string4);
    }

    public static ValidationException invalidInsertJobPropertyException(Collection<String> collection) {
        String string2 = collection.stream().map(string -> String.format(INVALID_PROPERTY_TEMPLATE, string)).collect(Collectors.joining("\n"));
        String string3 = String.format("Currently no job-specific options are allowed in INSERT SQL statements.\nInvalid options used:\n%s", string2);
        return new ValidationException(string3);
    }

    public static ValidationException invalidSelectJobPropertyException(Collection<String> collection) {
        String string2 = collection.stream().map(string -> String.format(INVALID_PROPERTY_TEMPLATE, string)).collect(Collectors.joining("\n"));
        String string3 = String.format("Only job-specific options are allowed in SELECT SQL statement.\nInvalid options used: \n%s\nAllowed options:\n%s", string2, ALLOWED_SELECT_JOB_SPECIFIC_OPTIONS);
        return new ValidationException(string3);
    }

    public static class InvalidDdlOptions {
        private final Set<String> jobSpecificOptions = new HashSet<String>();
        private final Set<String> invalidTableProperties = new HashSet<String>();

        public void addJobSpecificOption(String string) {
            this.jobSpecificOptions.add(string);
        }

        public void addInvalidTableProperty(String string) {
            this.invalidTableProperties.add(string);
        }

        public boolean hasInvalidOptions() {
            return !this.jobSpecificOptions.isEmpty() || !this.invalidTableProperties.isEmpty();
        }

        public Collection<String> getJobSpecificOptions() {
            return Collections.unmodifiableSet(this.jobSpecificOptions);
        }

        public Collection<String> getInvalidTableProperties() {
            return Collections.unmodifiableSet(this.invalidTableProperties);
        }
    }

    public static class MismatchedDdlOptionAndDeltaTableProperty {
        private final String optionName;
        private final String ddlOptionValue;
        private final String deltaLogPropertyValue;

        public MismatchedDdlOptionAndDeltaTableProperty(String string, String string2, String string3) {
            this.optionName = string;
            this.ddlOptionValue = string2;
            this.deltaLogPropertyValue = string3;
        }
    }
}

