/*
 * Decompiled with CFR 0.152.
 */
package io.delta.flink.internal.table;

import io.delta.flink.internal.table.CatalogLoader;
import io.delta.flink.internal.table.CatalogProxy;
import io.delta.flink.internal.table.DeltaCatalogContext;
import io.delta.flink.internal.table.HadoopUtils;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ConfigOptions;
import org.apache.flink.configuration.GlobalConfiguration;
import org.apache.flink.table.catalog.Catalog;
import org.apache.flink.table.catalog.exceptions.CatalogException;
import org.apache.flink.table.factories.CatalogFactory;
import org.apache.hadoop.conf.Configuration;

public class DeltaCatalogFactory
implements CatalogFactory {
    public static final String CATALOG_TYPE = "catalog-type";
    public static final String CATALOG_TYPE_HIVE = "hive";
    public static final String CATALOG_TYPE_IN_MEMORY = "in-memory";
    public static final ConfigOption<String> DEFAULT_DATABASE = ConfigOptions.key((String)"default-database").stringType().defaultValue((Object)"default");

    public Catalog createCatalog(CatalogFactory.Context context) {
        Map map = context.getOptions();
        HashMap<String, String> hashMap = new HashMap<String, String>(map);
        if (!hashMap.containsKey("default-database")) {
            hashMap.put(DEFAULT_DATABASE.key(), (String)DEFAULT_DATABASE.defaultValue());
        }
        DeltaCatalogContext deltaCatalogContext = new DeltaCatalogContext(context.getName(), hashMap, context.getConfiguration(), context.getClassLoader());
        Catalog catalog = this.createDecoratedCatalog(deltaCatalogContext);
        Configuration configuration = HadoopUtils.getHadoopConfiguration(GlobalConfiguration.loadConfiguration());
        return new CatalogProxy(context.getName(), "default", catalog, configuration);
    }

    public String factoryIdentifier() {
        return "delta-catalog";
    }

    private Catalog createDecoratedCatalog(CatalogFactory.Context context) {
        Map map = context.getOptions();
        String string = map.getOrDefault(CATALOG_TYPE, CATALOG_TYPE_IN_MEMORY);
        switch (string.toLowerCase(Locale.ENGLISH)) {
            case "hive": {
                return CatalogLoader.hive().createCatalog(context);
            }
            case "in-memory": {
                return CatalogLoader.inMemory().createCatalog(context);
            }
        }
        throw new CatalogException("Unknown catalog-type: " + string + " (Must be 'hive' or 'inMemory')");
    }
}

