/*
 * Decompiled with CFR 0.152.
 */
package io.delta.flink.source.internal.builder;

import io.delta.flink.source.internal.DeltaPartitionFieldExtractor;
import io.delta.flink.source.internal.DeltaSourceOptions;
import io.delta.flink.source.internal.builder.FormatBuilder;
import io.delta.flink.source.internal.builder.RowDataFormat;
import io.delta.flink.source.internal.state.DeltaSourceSplit;
import java.util.Collections;
import java.util.List;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.formats.parquet.ParquetColumnarRowInputFormat;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.runtime.typeutils.InternalTypeInfo;
import org.apache.flink.table.types.logical.RowType;
import org.apache.hadoop.conf.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RowDataFormatBuilder
implements FormatBuilder<RowData> {
    private static final Logger LOG = LoggerFactory.getLogger(RowDataFormatBuilder.class);
    private static final boolean PARQUET_UTC_TIMESTAMP = true;
    private static final boolean PARQUET_CASE_SENSITIVE = true;
    private final RowType rowType;
    private final Configuration hadoopConfiguration;
    private List<String> partitionColumns;
    private int batchSize = DeltaSourceOptions.PARQUET_BATCH_SIZE.defaultValue();

    RowDataFormatBuilder(RowType rowType, Configuration configuration) {
        this.rowType = rowType;
        this.hadoopConfiguration = configuration;
        this.partitionColumns = Collections.emptyList();
    }

    public RowDataFormatBuilder partitionColumns(List<String> list) {
        this.partitionColumns = list;
        return this;
    }

    @Override
    public FormatBuilder<RowData> parquetBatchSize(int n) {
        this.batchSize = n;
        return this;
    }

    public RowDataFormat build() {
        if (this.partitionColumns.isEmpty()) {
            LOG.info("Building format data for non-partitioned Delta table.");
            return this.buildFormatWithoutPartitions();
        }
        LOG.info("Building format data for partitioned Delta table.");
        return this.buildFormatWithPartitionColumns(this.rowType, this.hadoopConfiguration, this.partitionColumns);
    }

    private RowDataFormat buildFormatWithoutPartitions() {
        return this.buildFormatWithPartitionColumns(this.rowType, this.hadoopConfiguration, Collections.emptyList());
    }

    private RowDataFormat buildFormatWithPartitionColumns(RowType rowType, Configuration configuration, List<String> list) {
        ParquetColumnarRowInputFormat parquetColumnarRowInputFormat = ParquetColumnarRowInputFormat.createPartitionedFormat((Configuration)configuration, (RowType)rowType, (TypeInformation)InternalTypeInfo.of((RowType)rowType), list, new DeltaPartitionFieldExtractor(), (int)this.batchSize, (boolean)true, (boolean)true);
        return new RowDataFormat((ParquetColumnarRowInputFormat<DeltaSourceSplit>)parquetColumnarRowInputFormat);
    }
}

