/*
 * Decompiled with CFR 0.152.
 */
package io.delta.flink.source.internal.enumerator;

import io.delta.flink.internal.options.DeltaConnectorConfiguration;
import io.delta.flink.source.internal.DeltaSourceOptions;
import io.delta.flink.source.internal.enumerator.BoundedDeltaSourceSplitEnumerator;
import io.delta.flink.source.internal.enumerator.SplitEnumeratorProvider;
import io.delta.flink.source.internal.enumerator.processor.SnapshotProcessor;
import io.delta.flink.source.internal.file.AddFileEnumerator;
import io.delta.flink.source.internal.state.DeltaEnumeratorStateCheckpoint;
import io.delta.flink.source.internal.state.DeltaSourceSplit;
import io.delta.flink.source.internal.utils.SourceUtils;
import io.delta.standalone.DeltaLog;
import io.delta.standalone.Snapshot;
import java.util.Collections;
import org.apache.flink.api.connector.source.Boundedness;
import org.apache.flink.api.connector.source.SplitEnumeratorContext;
import org.apache.flink.connector.file.src.assigners.FileSplitAssigner;
import org.apache.flink.core.fs.Path;
import org.apache.hadoop.conf.Configuration;

public class BoundedSplitEnumeratorProvider
implements SplitEnumeratorProvider {
    private final FileSplitAssigner.Provider splitAssignerProvider;
    private final AddFileEnumerator.Provider<DeltaSourceSplit> fileEnumeratorProvider;

    public BoundedSplitEnumeratorProvider(FileSplitAssigner.Provider provider, AddFileEnumerator.Provider<DeltaSourceSplit> provider2) {
        this.splitAssignerProvider = provider;
        this.fileEnumeratorProvider = provider2;
    }

    public BoundedDeltaSourceSplitEnumerator createInitialStateEnumerator(Path path, Configuration configuration, SplitEnumeratorContext<DeltaSourceSplit> splitEnumeratorContext, DeltaConnectorConfiguration deltaConnectorConfiguration) {
        DeltaLog deltaLog = DeltaLog.forTable((Configuration)configuration, (String)SourceUtils.pathToString(path));
        Snapshot snapshot = deltaLog.getSnapshotForVersionAsOf(deltaConnectorConfiguration.getValue(DeltaSourceOptions.LOADED_SCHEMA_SNAPSHOT_VERSION).longValue());
        SnapshotProcessor snapshotProcessor = new SnapshotProcessor(path, snapshot, this.fileEnumeratorProvider.create(), Collections.emptySet());
        return new BoundedDeltaSourceSplitEnumerator(path, snapshotProcessor, this.splitAssignerProvider.create(Collections.emptyList()), splitEnumeratorContext);
    }

    public BoundedDeltaSourceSplitEnumerator createEnumeratorForCheckpoint(DeltaEnumeratorStateCheckpoint<DeltaSourceSplit> deltaEnumeratorStateCheckpoint, Configuration configuration, SplitEnumeratorContext<DeltaSourceSplit> splitEnumeratorContext, DeltaConnectorConfiguration deltaConnectorConfiguration) {
        DeltaLog deltaLog = DeltaLog.forTable((Configuration)configuration, (String)SourceUtils.pathToString(deltaEnumeratorStateCheckpoint.getDeltaTablePath()));
        SnapshotProcessor snapshotProcessor = new SnapshotProcessor(deltaEnumeratorStateCheckpoint.getDeltaTablePath(), deltaLog.getSnapshotForVersionAsOf(deltaEnumeratorStateCheckpoint.getSnapshotVersion()), this.fileEnumeratorProvider.create(), deltaEnumeratorStateCheckpoint.getAlreadyProcessedPaths());
        return new BoundedDeltaSourceSplitEnumerator(deltaEnumeratorStateCheckpoint.getDeltaTablePath(), snapshotProcessor, this.splitAssignerProvider.create(Collections.emptyList()), splitEnumeratorContext);
    }

    @Override
    public Boundedness getBoundedness() {
        return Boundedness.BOUNDED;
    }
}

