/*
 * Decompiled with CFR 0.152.
 */
package io.delta.flink.source.internal.enumerator;

import io.delta.flink.source.internal.state.DeltaEnumeratorStateCheckpoint;
import io.delta.flink.source.internal.state.DeltaSourceSplit;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.flink.api.connector.source.SourceSplit;
import org.apache.flink.api.connector.source.SplitEnumerator;
import org.apache.flink.api.connector.source.SplitEnumeratorContext;
import org.apache.flink.connector.file.src.FileSourceSplit;
import org.apache.flink.connector.file.src.assigners.FileSplitAssigner;
import org.apache.flink.core.fs.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DeltaSourceSplitEnumerator
implements SplitEnumerator<DeltaSourceSplit, DeltaEnumeratorStateCheckpoint<DeltaSourceSplit>> {
    private static final Logger LOG = LoggerFactory.getLogger(DeltaSourceSplitEnumerator.class);
    protected final Path deltaTablePath;
    protected final FileSplitAssigner splitAssigner;
    protected final SplitEnumeratorContext<DeltaSourceSplit> enumContext;
    protected final LinkedHashMap<Integer, String> readersAwaitingSplit;

    protected DeltaSourceSplitEnumerator(Path path, FileSplitAssigner fileSplitAssigner, SplitEnumeratorContext<DeltaSourceSplit> splitEnumeratorContext) {
        this.deltaTablePath = path;
        this.splitAssigner = fileSplitAssigner;
        this.enumContext = splitEnumeratorContext;
        this.readersAwaitingSplit = new LinkedHashMap();
    }

    public void handleSplitRequest(int n, @Nullable String string) {
        if (!this.enumContext.registeredReaders().containsKey(n)) {
            return;
        }
        if (LOG.isInfoEnabled()) {
            String string2 = string == null ? "(no host locality info)" : "(on host '" + string + "')";
            LOG.info("Subtask {} {} is requesting a file source split", (Object)n, (Object)string2);
        }
        this.readersAwaitingSplit.put(n, string);
        this.assignSplits(n);
    }

    public void addSplitsBack(List<DeltaSourceSplit> list, int n) {
        LOG.debug("Bounded Delta Source Enumerator adds splits back: {}", list);
        this.addSplits(list);
    }

    public void addReader(int n) {
    }

    public void close() throws IOException {
    }

    protected abstract void handleNoMoreSplits(int var1);

    protected Collection<DeltaSourceSplit> getRemainingSplits() {
        return this.splitAssigner.remainingSplits();
    }

    protected void addSplits(List<DeltaSourceSplit> list) {
        this.splitAssigner.addSplits(list);
    }

    protected AssignSplitStatus assignSplits() {
        Iterator<Map.Entry<Integer, String>> iterator = this.readersAwaitingSplit.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Integer, String> entry = iterator.next();
            if (!this.enumContext.registeredReaders().containsKey(entry.getKey())) {
                iterator.remove();
                continue;
            }
            String string = entry.getValue();
            int n = entry.getKey();
            Optional optional = this.splitAssigner.getNext(string);
            if (optional.isPresent()) {
                FileSourceSplit fileSourceSplit = (FileSourceSplit)optional.get();
                this.enumContext.assignSplit((SourceSplit)((DeltaSourceSplit)fileSourceSplit), n);
                LOG.info("Assigned split to subtask {} : {}", (Object)n, (Object)fileSourceSplit);
                iterator.remove();
                continue;
            }
            return AssignSplitStatus.NO_MORE_SPLITS;
        }
        return AssignSplitStatus.NO_MORE_READERS;
    }

    private void assignSplits(int n) {
        AssignSplitStatus assignSplitStatus = this.assignSplits();
        if (AssignSplitStatus.NO_MORE_SPLITS.equals((Object)assignSplitStatus)) {
            LOG.info("No more splits available for subtasks");
            this.handleNoMoreSplits(n);
        }
    }

    public static enum AssignSplitStatus {
        NO_MORE_SPLITS,
        NO_MORE_READERS;

    }
}

