/*
 * Decompiled with CFR 0.152.
 */
package io.delta.flink.source.internal.enumerator.processor;

import io.delta.flink.source.internal.enumerator.processor.ChangesProcessor;
import io.delta.flink.source.internal.enumerator.processor.ContinuousTableProcessor;
import io.delta.flink.source.internal.enumerator.processor.SnapshotProcessor;
import io.delta.flink.source.internal.state.DeltaEnumeratorStateCheckpointBuilder;
import io.delta.flink.source.internal.state.DeltaSourceSplit;
import java.util.List;
import java.util.function.Consumer;

public class SnapshotAndChangesTableProcessor
implements ContinuousTableProcessor {
    private final SnapshotProcessor snapshotProcessor;
    private final ChangesProcessor changesProcessor;
    private boolean monitoringForChanges;

    public SnapshotAndChangesTableProcessor(SnapshotProcessor snapshotProcessor, ChangesProcessor changesProcessor) {
        this.snapshotProcessor = snapshotProcessor;
        this.changesProcessor = changesProcessor;
        this.monitoringForChanges = false;
    }

    @Override
    public void process(Consumer<List<DeltaSourceSplit>> consumer) {
        this.snapshotProcessor.process(consumer);
        this.monitoringForChanges = true;
        this.changesProcessor.process(consumer);
    }

    @Override
    public boolean isMonitoringForChanges() {
        return this.monitoringForChanges;
    }

    @Override
    public long getSnapshotVersion() {
        return this.monitoringForChanges ? this.changesProcessor.getSnapshotVersion() : this.snapshotProcessor.getSnapshotVersion();
    }

    @Override
    public DeltaEnumeratorStateCheckpointBuilder<DeltaSourceSplit> snapshotState(DeltaEnumeratorStateCheckpointBuilder<DeltaSourceSplit> deltaEnumeratorStateCheckpointBuilder) {
        deltaEnumeratorStateCheckpointBuilder.withMonitoringForChanges(this.isMonitoringForChanges());
        deltaEnumeratorStateCheckpointBuilder = this.isMonitoringForChanges() ? this.changesProcessor.snapshotState(deltaEnumeratorStateCheckpointBuilder) : this.snapshotProcessor.snapshotState(deltaEnumeratorStateCheckpointBuilder);
        return deltaEnumeratorStateCheckpointBuilder;
    }
}

