/*
 * Decompiled with CFR 0.152.
 */
package io.delta.flink.source.internal.enumerator.processor;

import io.delta.flink.source.internal.enumerator.monitor.ChangesPerVersion;
import io.delta.flink.source.internal.enumerator.processor.TableProcessorBase;
import io.delta.flink.source.internal.file.AddFileEnumerator;
import io.delta.flink.source.internal.state.DeltaEnumeratorStateCheckpointBuilder;
import io.delta.flink.source.internal.state.DeltaSourceSplit;
import io.delta.flink.source.internal.utils.SourceUtils;
import io.delta.standalone.Snapshot;
import io.delta.standalone.actions.AddFile;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.function.Consumer;
import org.apache.flink.core.fs.Path;

public class SnapshotProcessor
extends TableProcessorBase {
    private final Snapshot snapshot;
    private final HashSet<Path> alreadyProcessedPaths;

    public SnapshotProcessor(Path path, Snapshot snapshot, AddFileEnumerator<DeltaSourceSplit> addFileEnumerator, Collection<Path> collection) {
        super(path, addFileEnumerator);
        this.snapshot = snapshot;
        this.alreadyProcessedPaths = new HashSet<Path>(collection);
    }

    @Override
    public void process(Consumer<List<DeltaSourceSplit>> consumer) {
        List<DeltaSourceSplit> list = this.prepareSplits(new ChangesPerVersion<AddFile>(SourceUtils.pathToString(this.deltaTablePath), this.snapshot.getVersion(), this.snapshot.getAllFiles()), this.alreadyProcessedPaths::add);
        consumer.accept(list);
    }

    @Override
    public DeltaEnumeratorStateCheckpointBuilder<DeltaSourceSplit> snapshotState(DeltaEnumeratorStateCheckpointBuilder<DeltaSourceSplit> deltaEnumeratorStateCheckpointBuilder) {
        deltaEnumeratorStateCheckpointBuilder.withProcessedPaths(this.alreadyProcessedPaths);
        deltaEnumeratorStateCheckpointBuilder.withMonitoringForChanges(false);
        return deltaEnumeratorStateCheckpointBuilder;
    }

    @Override
    public long getSnapshotVersion() {
        return this.snapshot.getVersion();
    }
}

