/*
 * Decompiled with CFR 0.152.
 */
package io.delta.flink.source.internal.exceptions;

import io.delta.flink.source.internal.exceptions.DeltaSourceException;
import io.delta.flink.source.internal.file.AddFileEnumeratorContext;
import io.delta.standalone.actions.Action;
import java.io.IOException;
import java.util.Collection;
import org.apache.flink.core.fs.Path;

public final class DeltaSourceExceptions {
    private DeltaSourceExceptions() {
    }

    public static DeltaSourceException generalSourceException(String string, long l, Throwable throwable) {
        return new DeltaSourceException(string, (Long)l, throwable);
    }

    public static DeltaSourceException fileEnumerationException(AddFileEnumeratorContext addFileEnumeratorContext, Path path, IOException iOException) {
        return new DeltaSourceException(addFileEnumeratorContext.getTablePath(), addFileEnumeratorContext.getSnapshotVersion(), String.format("An Exception while processing Parquet Files for path %s and version %d", path, addFileEnumeratorContext.getSnapshotVersion()), iOException);
    }

    public static DeltaSourceException deltaSourceIgnoreChangesException(String string, long l) {
        return new DeltaSourceException(string, (Long)l, String.format("Detected a data update in the source table at version %d. This is currently not supported. If you'd like to ignore updates, set the option 'ignoreChanges' to 'true'. If you would like the data update to be reflected, please restart this query with a fresh Delta checkpoint directory.", l));
    }

    public static DeltaSourceException deltaSourceIgnoreDeleteException(String string, long l) {
        return new DeltaSourceException(string, (Long)l, String.format("Detected deleted data (for example $removedFile) from streaming source at version %d. This is currently not supported. If you'd like to ignore deletes set the option 'ignoreDeletes' to 'true'.", l));
    }

    public static DeltaSourceException tableMonitorException(String string, Throwable throwable) {
        return new DeltaSourceException(string, null, String.format("Exception during monitoring Delta table [%s] for changes", string), throwable);
    }

    public static DeltaSourceException unsupportedDeltaActionException(String string, long l, Action action) {
        return new DeltaSourceException(string, (Long)l, String.format("Got an unsupported action - [%s] when processing changes from version [%d] for table [%s]", action.getClass(), l, string));
    }

    public static DeltaSourceException notPartitionedTableException(String string) {
        return new DeltaSourceException(String.format("Attempt to get a value for partition column from unpartitioned Delta Table. Column name %s", string));
    }

    public static DeltaSourceException missingPartitionValueException(String string, Collection<String> collection) {
        return new DeltaSourceException(String.format("Cannot find the partition value in Delta MetaData for column %s. Expected partition column names from MetaData are %s", string, collection));
    }
}

