/*
 * Decompiled with CFR 0.152.
 */
package io.delta.flink.source.internal.state;

import io.delta.flink.source.internal.state.DeltaEnumeratorStateCheckpoint;
import io.delta.flink.source.internal.state.DeltaSourceSplit;
import io.delta.flink.source.internal.utils.SourceUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import org.apache.flink.connector.file.src.PendingSplitsCheckpoint;
import org.apache.flink.connector.file.src.PendingSplitsCheckpointSerializer;
import org.apache.flink.core.fs.Path;
import org.apache.flink.core.io.SimpleVersionedSerializer;
import org.apache.flink.core.memory.DataInputViewStreamWrapper;
import org.apache.flink.core.memory.DataOutputViewStreamWrapper;
import org.apache.flink.util.Preconditions;

public class DeltaPendingSplitsCheckpointSerializer<SplitT extends DeltaSourceSplit>
implements SimpleVersionedSerializer<DeltaEnumeratorStateCheckpoint<SplitT>> {
    private static final int VERSION = 1;
    private final PendingSplitsCheckpointSerializer<SplitT> decoratedSerDe;

    public DeltaPendingSplitsCheckpointSerializer(SimpleVersionedSerializer<SplitT> simpleVersionedSerializer) {
        this.decoratedSerDe = new PendingSplitsCheckpointSerializer(simpleVersionedSerializer);
    }

    public int getVersion() {
        return 1;
    }

    public byte[] serialize(DeltaEnumeratorStateCheckpoint<SplitT> deltaEnumeratorStateCheckpoint) throws IOException {
        Preconditions.checkArgument((deltaEnumeratorStateCheckpoint.getClass() == DeltaEnumeratorStateCheckpoint.class ? 1 : 0) != 0, (String)"Only supports %s", (Object[])new Object[]{DeltaEnumeratorStateCheckpoint.class.getName()});
        PendingSplitsCheckpoint<SplitT> pendingSplitsCheckpoint = deltaEnumeratorStateCheckpoint.getPendingSplitsCheckpoint();
        byte[] byArray = this.decoratedSerDe.serialize(pendingSplitsCheckpoint);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try (DataOutputViewStreamWrapper dataOutputViewStreamWrapper = new DataOutputViewStreamWrapper((OutputStream)byteArrayOutputStream);){
            dataOutputViewStreamWrapper.writeInt(byArray.length);
            dataOutputViewStreamWrapper.write(byArray);
            dataOutputViewStreamWrapper.writeLong(deltaEnumeratorStateCheckpoint.getSnapshotVersion());
            dataOutputViewStreamWrapper.writeBoolean(deltaEnumeratorStateCheckpoint.isMonitoringForChanges());
            byte[] byArray2 = SourceUtils.pathToString(deltaEnumeratorStateCheckpoint.getDeltaTablePath()).getBytes(StandardCharsets.UTF_8);
            dataOutputViewStreamWrapper.writeInt(byArray2.length);
            dataOutputViewStreamWrapper.write(byArray2);
        }
        return byteArrayOutputStream.toByteArray();
    }

    public DeltaEnumeratorStateCheckpoint<SplitT> deserialize(int n, byte[] byArray) throws IOException {
        if (n == 1) {
            return this.tryDeserializeV1(byArray);
        }
        throw new IOException("Unknown version: " + n);
    }

    private DeltaEnumeratorStateCheckpoint<SplitT> tryDeserializeV1(byte[] byArray) throws IOException {
        try (DataInputViewStreamWrapper dataInputViewStreamWrapper = new DataInputViewStreamWrapper((InputStream)new ByteArrayInputStream(byArray));){
            DeltaEnumeratorStateCheckpoint<SplitT> deltaEnumeratorStateCheckpoint = this.deserializeV1(dataInputViewStreamWrapper);
            return deltaEnumeratorStateCheckpoint;
        }
    }

    private DeltaEnumeratorStateCheckpoint<SplitT> deserializeV1(DataInputViewStreamWrapper dataInputViewStreamWrapper) throws IOException {
        byte[] byArray = new byte[dataInputViewStreamWrapper.readInt()];
        dataInputViewStreamWrapper.readFully(byArray);
        PendingSplitsCheckpoint pendingSplitsCheckpoint = this.decoratedSerDe.deserialize(this.decoratedSerDe.getVersion(), byArray);
        long l = dataInputViewStreamWrapper.readLong();
        boolean bl = dataInputViewStreamWrapper.readBoolean();
        byte[] byArray2 = new byte[dataInputViewStreamWrapper.readInt()];
        dataInputViewStreamWrapper.readFully(byArray2);
        Path path = new Path(new String(byArray2, StandardCharsets.UTF_8));
        return new DeltaEnumeratorStateCheckpoint(path, l, bl, pendingSplitsCheckpoint);
    }
}

