/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.functions.sink.filesystem;

import java.io.IOException;
import org.apache.flink.api.common.serialization.BulkWriter;
import org.apache.flink.core.fs.RecoverableFsDataOutputStream;
import org.apache.flink.streaming.api.functions.sink.filesystem.AbstractPartFileWriter;
import org.apache.flink.streaming.api.functions.sink.filesystem.InProgressFileWriter;
import org.apache.flink.streaming.api.functions.sink.filesystem.OutputStreamBasedPartFileWriter;
import org.apache.flink.util.IOUtils;
import org.apache.flink.util.Preconditions;

public class DeltaBulkPartWriter<IN, BucketID>
extends AbstractPartFileWriter<IN, BucketID> {
    final RecoverableFsDataOutputStream currentPartStream;
    private final BulkWriter<IN> writer;
    private boolean closed = false;

    public DeltaBulkPartWriter(BucketID BucketID, RecoverableFsDataOutputStream recoverableFsDataOutputStream, BulkWriter<IN> bulkWriter, long l) {
        super(BucketID, l);
        this.currentPartStream = recoverableFsDataOutputStream;
        this.writer = (BulkWriter)Preconditions.checkNotNull(bulkWriter);
    }

    public void closeWriter() throws IOException {
        this.writer.flush();
        this.writer.finish();
        this.closed = true;
    }

    public void write(IN IN, long l) throws IOException {
        this.writer.addElement(IN);
        this.markWrite(l);
    }

    public InProgressFileWriter.InProgressFileRecoverable persist() {
        throw new UnsupportedOperationException("Bulk Part Writers do not support \"pause and resume\" operations.");
    }

    public InProgressFileWriter.PendingFileRecoverable closeForCommit() throws IOException {
        if (!this.closed) {
            this.closeWriter();
        }
        return new OutputStreamBasedPartFileWriter.OutputStreamBasedPendingFileRecoverable(this.currentPartStream.closeForCommit().getRecoverable());
    }

    public void dispose() {
        IOUtils.closeQuietly((AutoCloseable)this.currentPartStream);
    }

    public long getSize() throws IOException {
        return this.currentPartStream.getPos();
    }
}

