/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.functions.sink.filesystem;

import io.delta.standalone.actions.AddFile;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.flink.core.io.SimpleVersionedSerialization;
import org.apache.flink.core.io.SimpleVersionedSerializer;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.streaming.api.functions.sink.filesystem.InProgressFileWriter;
import org.apache.flink.table.utils.PartitionPathUtils;

public class DeltaPendingFile {
    private final LinkedHashMap<String, String> partitionSpec;
    private final String fileName;
    private final InProgressFileWriter.PendingFileRecoverable pendingFile;
    private final long recordCount;
    private final long fileSize;
    private final long lastUpdateTime;

    public DeltaPendingFile(LinkedHashMap<String, String> linkedHashMap, String string, InProgressFileWriter.PendingFileRecoverable pendingFileRecoverable, long l, long l2, long l3) {
        this.partitionSpec = linkedHashMap;
        this.fileName = string;
        this.pendingFile = pendingFileRecoverable;
        this.fileSize = l2;
        this.recordCount = l;
        this.lastUpdateTime = l3;
    }

    public String getFileName() {
        return this.fileName;
    }

    public InProgressFileWriter.PendingFileRecoverable getPendingFile() {
        return this.pendingFile;
    }

    public long getFileSize() {
        return this.fileSize;
    }

    public long getRecordCount() {
        return this.recordCount;
    }

    public long getLastUpdateTime() {
        return this.lastUpdateTime;
    }

    public LinkedHashMap<String, String> getPartitionSpec() {
        return new LinkedHashMap<String, String>(this.partitionSpec);
    }

    public AddFile toAddFile() {
        LinkedHashMap<String, String> linkedHashMap = this.getPartitionSpec();
        long l = this.getLastUpdateTime();
        String string = PartitionPathUtils.generatePartitionPath(linkedHashMap) + this.getFileName();
        return new AddFile(string, linkedHashMap, this.getFileSize(), l, true, null, null);
    }

    public static void serialize(DeltaPendingFile deltaPendingFile, DataOutputView dataOutputView, SimpleVersionedSerializer<InProgressFileWriter.PendingFileRecoverable> simpleVersionedSerializer) throws IOException {
        assert (deltaPendingFile.getFileName() != null);
        assert (deltaPendingFile.getPendingFile() != null);
        dataOutputView.writeInt(deltaPendingFile.getPartitionSpec().size());
        for (Map.Entry<String, String> entry : deltaPendingFile.getPartitionSpec().entrySet()) {
            dataOutputView.writeUTF(entry.getKey());
            dataOutputView.writeUTF(entry.getValue());
        }
        dataOutputView.writeUTF(deltaPendingFile.getFileName());
        dataOutputView.writeLong(deltaPendingFile.getRecordCount());
        dataOutputView.writeLong(deltaPendingFile.getFileSize());
        dataOutputView.writeLong(deltaPendingFile.getLastUpdateTime());
        SimpleVersionedSerialization.writeVersionAndSerialize(simpleVersionedSerializer, (Object)deltaPendingFile.getPendingFile(), (DataOutputView)dataOutputView);
    }

    public static DeltaPendingFile deserialize(DataInputView dataInputView, SimpleVersionedSerializer<InProgressFileWriter.PendingFileRecoverable> simpleVersionedSerializer) throws IOException {
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        int n = dataInputView.readInt();
        for (int i = 0; i < n; ++i) {
            linkedHashMap.put(dataInputView.readUTF(), dataInputView.readUTF());
        }
        String string = dataInputView.readUTF();
        long l = dataInputView.readLong();
        long l2 = dataInputView.readLong();
        long l3 = dataInputView.readLong();
        InProgressFileWriter.PendingFileRecoverable pendingFileRecoverable = (InProgressFileWriter.PendingFileRecoverable)SimpleVersionedSerialization.readVersionAndDeSerialize(simpleVersionedSerializer, (DataInputView)dataInputView);
        return new DeltaPendingFile(linkedHashMap, string, pendingFileRecoverable, l, l2, l3);
    }

    public String toString() {
        String string2 = this.partitionSpec.keySet().stream().map(string -> string + "=" + this.partitionSpec.get(string)).collect(Collectors.joining(", ", "{", "}"));
        return "DeltaPendingFile(fileName=" + this.fileName + " lastUpdateTime=" + this.lastUpdateTime + " fileSize=" + this.fileSize + " recordCount=" + this.recordCount + " partitionSpec=" + string2 + ")";
    }
}

