/*
 * Decompiled with CFR 0.152.
 */
package io.delta.flink.internal.table;

import io.delta.flink.internal.table.BaseCatalog;
import io.delta.flink.internal.table.DeltaCatalog;
import io.delta.flink.internal.table.DeltaCatalogBaseTable;
import java.util.Collections;
import java.util.List;
import org.apache.flink.table.catalog.Catalog;
import org.apache.flink.table.catalog.CatalogBaseTable;
import org.apache.flink.table.catalog.CatalogPartition;
import org.apache.flink.table.catalog.CatalogPartitionSpec;
import org.apache.flink.table.catalog.ObjectPath;
import org.apache.flink.table.catalog.exceptions.CatalogException;
import org.apache.flink.table.catalog.exceptions.DatabaseNotExistException;
import org.apache.flink.table.catalog.exceptions.PartitionAlreadyExistsException;
import org.apache.flink.table.catalog.exceptions.PartitionNotExistException;
import org.apache.flink.table.catalog.exceptions.PartitionSpecInvalidException;
import org.apache.flink.table.catalog.exceptions.TableAlreadyExistException;
import org.apache.flink.table.catalog.exceptions.TableNotExistException;
import org.apache.flink.table.catalog.exceptions.TableNotPartitionedException;
import org.apache.flink.table.catalog.exceptions.TablePartitionedException;
import org.apache.flink.table.catalog.stats.CatalogColumnStatistics;
import org.apache.flink.table.catalog.stats.CatalogTableStatistics;
import org.apache.flink.table.expressions.Expression;
import org.apache.hadoop.conf.Configuration;

public class CatalogProxy
extends BaseCatalog {
    private final DeltaCatalog deltaCatalog;

    public CatalogProxy(String string, String string2, Catalog catalog, Configuration configuration) {
        super(string, string2, catalog);
        this.deltaCatalog = new DeltaCatalog(string, catalog, configuration);
    }

    public CatalogBaseTable getTable(ObjectPath objectPath) throws TableNotExistException {
        DeltaCatalogBaseTable deltaCatalogBaseTable = this.getCatalogTableUnchecked(objectPath);
        if (deltaCatalogBaseTable.isDeltaTable()) {
            return this.deltaCatalog.getTable(deltaCatalogBaseTable);
        }
        return deltaCatalogBaseTable.getCatalogTable();
    }

    public boolean tableExists(ObjectPath objectPath) throws CatalogException {
        DeltaCatalogBaseTable deltaCatalogBaseTable = this.getCatalogTable(objectPath);
        if (deltaCatalogBaseTable.isDeltaTable()) {
            return this.deltaCatalog.tableExists(deltaCatalogBaseTable);
        }
        return this.decoratedCatalog.tableExists(objectPath);
    }

    public void createTable(ObjectPath objectPath, CatalogBaseTable catalogBaseTable, boolean bl) throws TableAlreadyExistException, DatabaseNotExistException, CatalogException {
        DeltaCatalogBaseTable deltaCatalogBaseTable = new DeltaCatalogBaseTable(objectPath, catalogBaseTable);
        if (deltaCatalogBaseTable.isDeltaTable()) {
            this.deltaCatalog.createTable(deltaCatalogBaseTable, bl);
        } else {
            this.decoratedCatalog.createTable(objectPath, catalogBaseTable, bl);
        }
    }

    public void dropTable(ObjectPath objectPath, boolean bl) throws TableNotExistException, CatalogException {
        DeltaCatalogBaseTable deltaCatalogBaseTable = this.getCatalogTable(objectPath);
        if (deltaCatalogBaseTable.isDeltaTable()) {
            this.deltaCatalog.dropTable(deltaCatalogBaseTable, bl);
        } else {
            this.decoratedCatalog.dropTable(objectPath, bl);
        }
    }

    public void alterTable(ObjectPath objectPath, CatalogBaseTable catalogBaseTable, boolean bl) throws TableNotExistException, CatalogException {
        DeltaCatalogBaseTable deltaCatalogBaseTable = new DeltaCatalogBaseTable(objectPath, catalogBaseTable);
        if (deltaCatalogBaseTable.isDeltaTable()) {
            this.deltaCatalog.alterTable(deltaCatalogBaseTable);
        } else {
            this.decoratedCatalog.alterTable(objectPath, catalogBaseTable, bl);
        }
    }

    public List<CatalogPartitionSpec> listPartitions(ObjectPath objectPath) throws TableNotExistException, TableNotPartitionedException, CatalogException {
        DeltaCatalogBaseTable deltaCatalogBaseTable = this.getCatalogTable(objectPath);
        if (deltaCatalogBaseTable.isDeltaTable()) {
            return Collections.emptyList();
        }
        return this.decoratedCatalog.listPartitions(objectPath);
    }

    public List<CatalogPartitionSpec> listPartitions(ObjectPath objectPath, CatalogPartitionSpec catalogPartitionSpec) throws CatalogException, TableNotPartitionedException, TableNotExistException, PartitionSpecInvalidException {
        DeltaCatalogBaseTable deltaCatalogBaseTable = this.getCatalogTable(objectPath);
        if (deltaCatalogBaseTable.isDeltaTable()) {
            throw new CatalogException("Delta table connector does not support partition listing.");
        }
        return this.decoratedCatalog.listPartitions(objectPath, catalogPartitionSpec);
    }

    public List<CatalogPartitionSpec> listPartitionsByFilter(ObjectPath objectPath, List<Expression> list) throws TableNotExistException, TableNotPartitionedException, CatalogException {
        DeltaCatalogBaseTable deltaCatalogBaseTable = this.getCatalogTable(objectPath);
        if (deltaCatalogBaseTable.isDeltaTable()) {
            throw new CatalogException("Delta table connector does not support partition listing by filter.");
        }
        return this.decoratedCatalog.listPartitionsByFilter(objectPath, list);
    }

    public CatalogPartition getPartition(ObjectPath objectPath, CatalogPartitionSpec catalogPartitionSpec) throws PartitionNotExistException, CatalogException {
        DeltaCatalogBaseTable deltaCatalogBaseTable = this.getCatalogTable(objectPath);
        if (deltaCatalogBaseTable.isDeltaTable()) {
            throw new CatalogException("Delta table connector does not support partition listing.");
        }
        return this.decoratedCatalog.getPartition(objectPath, catalogPartitionSpec);
    }

    public boolean partitionExists(ObjectPath objectPath, CatalogPartitionSpec catalogPartitionSpec) throws CatalogException {
        DeltaCatalogBaseTable deltaCatalogBaseTable = this.getCatalogTable(objectPath);
        if (deltaCatalogBaseTable.isDeltaTable()) {
            throw new CatalogException("Delta table connector does not support partition listing.");
        }
        return this.decoratedCatalog.partitionExists(objectPath, catalogPartitionSpec);
    }

    public void createPartition(ObjectPath objectPath, CatalogPartitionSpec catalogPartitionSpec, CatalogPartition catalogPartition, boolean bl) throws TableNotExistException, TableNotPartitionedException, PartitionSpecInvalidException, PartitionAlreadyExistsException, CatalogException {
        DeltaCatalogBaseTable deltaCatalogBaseTable = this.getCatalogTable(objectPath);
        if (deltaCatalogBaseTable.isDeltaTable()) {
            throw new CatalogException("Delta table connector does not support partition creation.");
        }
        this.decoratedCatalog.createPartition(objectPath, catalogPartitionSpec, catalogPartition, bl);
    }

    public void dropPartition(ObjectPath objectPath, CatalogPartitionSpec catalogPartitionSpec, boolean bl) throws PartitionNotExistException, CatalogException {
        DeltaCatalogBaseTable deltaCatalogBaseTable = this.getCatalogTable(objectPath);
        if (deltaCatalogBaseTable.isDeltaTable()) {
            throw new CatalogException("Delta table connector does not support partition drop operation.");
        }
        this.decoratedCatalog.dropPartition(objectPath, catalogPartitionSpec, bl);
    }

    public void alterPartition(ObjectPath objectPath, CatalogPartitionSpec catalogPartitionSpec, CatalogPartition catalogPartition, boolean bl) throws PartitionNotExistException, CatalogException {
        DeltaCatalogBaseTable deltaCatalogBaseTable = this.getCatalogTable(objectPath);
        if (deltaCatalogBaseTable.isDeltaTable()) {
            throw new CatalogException("Delta table connector does not support alter partition operation.");
        }
        this.decoratedCatalog.alterPartition(objectPath, catalogPartitionSpec, catalogPartition, bl);
    }

    public CatalogTableStatistics getTableStatistics(ObjectPath objectPath) throws TableNotExistException, CatalogException {
        if (this.getCatalogTable(objectPath).isDeltaTable()) {
            return CatalogTableStatistics.UNKNOWN;
        }
        return this.decoratedCatalog.getTableStatistics(objectPath);
    }

    public CatalogColumnStatistics getTableColumnStatistics(ObjectPath objectPath) throws TableNotExistException, CatalogException {
        if (this.getCatalogTable(objectPath).isDeltaTable()) {
            return CatalogColumnStatistics.UNKNOWN;
        }
        return this.decoratedCatalog.getTableColumnStatistics(objectPath);
    }

    public CatalogTableStatistics getPartitionStatistics(ObjectPath objectPath, CatalogPartitionSpec catalogPartitionSpec) throws PartitionNotExistException, CatalogException {
        if (this.getCatalogTable(objectPath).isDeltaTable()) {
            throw new CatalogException("Delta table connector does not support partition statistics.");
        }
        return this.decoratedCatalog.getPartitionStatistics(objectPath, catalogPartitionSpec);
    }

    public CatalogColumnStatistics getPartitionColumnStatistics(ObjectPath objectPath, CatalogPartitionSpec catalogPartitionSpec) throws PartitionNotExistException, CatalogException {
        if (this.getCatalogTable(objectPath).isDeltaTable()) {
            throw new CatalogException("Delta table connector does not support partition column statistics.");
        }
        return this.decoratedCatalog.getPartitionColumnStatistics(objectPath, catalogPartitionSpec);
    }

    public void alterTableStatistics(ObjectPath objectPath, CatalogTableStatistics catalogTableStatistics, boolean bl) throws TableNotExistException, CatalogException {
        if (this.getCatalogTable(objectPath).isDeltaTable()) {
            throw new CatalogException("Delta table connector does not support alter table statistics.");
        }
        this.decoratedCatalog.alterTableStatistics(objectPath, catalogTableStatistics, bl);
    }

    public void alterTableColumnStatistics(ObjectPath objectPath, CatalogColumnStatistics catalogColumnStatistics, boolean bl) throws TableNotExistException, CatalogException, TablePartitionedException {
        if (this.getCatalogTable(objectPath).isDeltaTable()) {
            throw new CatalogException("Delta table connector does not support alter table column statistics.");
        }
        this.decoratedCatalog.alterTableColumnStatistics(objectPath, catalogColumnStatistics, bl);
    }

    public void alterPartitionStatistics(ObjectPath objectPath, CatalogPartitionSpec catalogPartitionSpec, CatalogTableStatistics catalogTableStatistics, boolean bl) throws PartitionNotExistException, CatalogException {
        if (this.getCatalogTable(objectPath).isDeltaTable()) {
            throw new CatalogException("Delta table connector does not support alter partition statistics.");
        }
        this.decoratedCatalog.alterPartitionStatistics(objectPath, catalogPartitionSpec, catalogTableStatistics, bl);
    }

    public void alterPartitionColumnStatistics(ObjectPath objectPath, CatalogPartitionSpec catalogPartitionSpec, CatalogColumnStatistics catalogColumnStatistics, boolean bl) throws PartitionNotExistException, CatalogException {
        if (this.getCatalogTable(objectPath).isDeltaTable()) {
            throw new CatalogException("Delta table connector does not support alter partition column statistics.");
        }
        this.decoratedCatalog.alterPartitionColumnStatistics(objectPath, catalogPartitionSpec, catalogColumnStatistics, bl);
    }

    private DeltaCatalogBaseTable getCatalogTable(ObjectPath objectPath) {
        try {
            return this.getCatalogTableUnchecked(objectPath);
        }
        catch (TableNotExistException tableNotExistException) {
            throw new CatalogException((Throwable)tableNotExistException);
        }
    }

    private DeltaCatalogBaseTable getCatalogTableUnchecked(ObjectPath objectPath) throws TableNotExistException {
        CatalogBaseTable catalogBaseTable = this.decoratedCatalog.getTable(objectPath);
        return new DeltaCatalogBaseTable(objectPath, catalogBaseTable);
    }
}

