/*
 * Decompiled with CFR 0.152.
 */
package io.delta.flink.internal.table;

import java.util.Map;
import javax.annotation.Nonnull;
import org.apache.flink.table.catalog.CatalogBaseTable;
import org.apache.flink.table.catalog.ObjectPath;
import org.apache.flink.table.factories.FactoryUtil;
import org.apache.flink.util.Preconditions;

public class DeltaCatalogBaseTable {
    @Nonnull
    private final ObjectPath tableCatalogPath;
    @Nonnull
    private final CatalogBaseTable catalogTable;
    private final boolean isDeltaTable;

    public DeltaCatalogBaseTable(ObjectPath objectPath, CatalogBaseTable catalogBaseTable) {
        Preconditions.checkNotNull((Object)objectPath, (String)"Object path cannot be null for DeltaCatalogBaseTable.");
        Preconditions.checkNotNull((Object)catalogBaseTable, (String)"Catalog table cannot be null for DeltaCatalogBaseTable.");
        this.tableCatalogPath = objectPath;
        this.catalogTable = catalogBaseTable;
        String string = (String)catalogBaseTable.getOptions().get(FactoryUtil.CONNECTOR.key());
        this.isDeltaTable = "delta".equals(string);
    }

    public ObjectPath getTableCatalogPath() {
        return this.tableCatalogPath;
    }

    public CatalogBaseTable getCatalogTable() {
        return this.catalogTable;
    }

    public boolean isDeltaTable() {
        return this.isDeltaTable;
    }

    public Map<String, String> getOptions() {
        return this.catalogTable.getOptions();
    }

    public String getDatabaseName() {
        return this.tableCatalogPath.getDatabaseName();
    }
}

