/*
 * Decompiled with CFR 0.152.
 */
package io.delta.flink.sink.internal;

import io.delta.flink.sink.internal.DeltaSinkBuilder;
import io.delta.flink.sink.internal.committables.DeltaCommittable;
import io.delta.flink.sink.internal.committables.DeltaGlobalCommittable;
import io.delta.flink.sink.internal.writer.DeltaWriter;
import io.delta.flink.sink.internal.writer.DeltaWriterBucketState;
import java.io.IOException;
import java.util.List;
import java.util.Optional;
import org.apache.flink.api.connector.sink.Committer;
import org.apache.flink.api.connector.sink.GlobalCommitter;
import org.apache.flink.api.connector.sink.Sink;
import org.apache.flink.api.connector.sink.SinkWriter;
import org.apache.flink.core.io.SimpleVersionedSerializer;
import org.apache.flink.util.FlinkRuntimeException;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeltaSinkInternal<IN>
implements Sink<IN, DeltaCommittable, DeltaWriterBucketState, DeltaGlobalCommittable> {
    private static final Logger LOG = LoggerFactory.getLogger(DeltaSinkInternal.class);
    private final DeltaSinkBuilder<IN> sinkBuilder;

    protected DeltaSinkInternal(DeltaSinkBuilder<IN> deltaSinkBuilder) {
        this.sinkBuilder = (DeltaSinkBuilder)Preconditions.checkNotNull(deltaSinkBuilder);
    }

    public SinkWriter<IN, DeltaCommittable, DeltaWriterBucketState> createWriter(Sink.InitContext initContext, List<DeltaWriterBucketState> list) throws IOException {
        String string = this.restoreOrCreateAppId(list);
        long l = initContext.getRestoredCheckpointId().orElse(1L);
        DeltaWriter<IN> deltaWriter = this.sinkBuilder.createWriter(initContext, string, l);
        deltaWriter.initializeState(list);
        LOG.info("Created new writer for: appId=" + string + " checkpointId=" + l);
        return deltaWriter;
    }

    private String restoreOrCreateAppId(List<DeltaWriterBucketState> list) {
        if (list.isEmpty()) {
            return this.sinkBuilder.getAppId();
        }
        return list.get(0).getAppId();
    }

    public Optional<SimpleVersionedSerializer<DeltaWriterBucketState>> getWriterStateSerializer() {
        try {
            return Optional.of(this.sinkBuilder.getWriterStateSerializer());
        }
        catch (IOException iOException) {
            throw new FlinkRuntimeException("Could not create writer state serializer.", (Throwable)iOException);
        }
    }

    public Optional<Committer<DeltaCommittable>> createCommitter() throws IOException {
        return Optional.of(this.sinkBuilder.createCommitter());
    }

    public Optional<SimpleVersionedSerializer<DeltaCommittable>> getCommittableSerializer() {
        try {
            return Optional.of(this.sinkBuilder.getCommittableSerializer());
        }
        catch (IOException iOException) {
            throw new FlinkRuntimeException("Could not create committable serializer.", (Throwable)iOException);
        }
    }

    public Optional<GlobalCommitter<DeltaCommittable, DeltaGlobalCommittable>> createGlobalCommitter() {
        return Optional.of(this.sinkBuilder.createGlobalCommitter());
    }

    public Optional<SimpleVersionedSerializer<DeltaGlobalCommittable>> getGlobalCommittableSerializer() {
        try {
            return Optional.of(this.sinkBuilder.getGlobalCommittableSerializer());
        }
        catch (IOException iOException) {
            throw new FlinkRuntimeException("Could not create committable serializer.", (Throwable)iOException);
        }
    }
}

